<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Api;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ItemList;
use Publikat\Model\Xml\ModelInterface;

/**
 * ApiCall
 *
 * @Serializer\XmlRoot("ApiCall")
 * @Serializer\ExclusionPolicy("all")
 */
class ApiCall implements ModelInterface
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Method")
     * @Serializer\Type("string")
     *
     */
    private $method;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Authentication")
     * @Serializer\Type("string")
     *
     */
    private $authentication;

    /**
     * @var ItemList
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ParameterList")
     * @Serializer\Type("Publikat\Model\Xml\ItemList")
     *
     */
    private $parameterList;

    /**
     * @var \Publikat\Model\Xml\Api\ApiCall
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("BeforeApiCall")
     * @Serializer\Type("Publikat\Model\Xml\Api\ApiCall")
     *
     */
    private $beforeApiCall;

    /**
     * @var \Publikat\Model\Xml\Api\ApiCall
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("AfterApiCall")
     * @Serializer\Type("Publikat\Model\Xml\Api\ApiCall")
     *
     */
    private $afterApiCall;

    /**
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }

    /**
     * @param string $method
     *
     * @return ApiCall
     */
    public function setMethod($method)
    {
        $this->method = $method;

        return $this;
    }

    /**
     * @return string
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }

    /**
     * @param string $authentication
     *
     * @return ApiCall
     */
    public function setAuthentication($authentication)
    {
        $this->authentication = $authentication;

        return $this;
    }

    /**
     * @return ItemList
     */
    public function getParameterList()
    {
        return $this->parameterList;
    }

    /**
     * @param ItemList $parameterList
     *
     * @return ApiCall
     */
    public function setParameterList($parameterList)
    {
        $this->parameterList = $parameterList;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getBeforeApiCall()
    {
        return $this->beforeApiCall;
    }

    /**
     * @param mixed $beforeApiCall
     *
     * @return ApiCall
     */
    public function setBeforeApiCall($beforeApiCall)
    {
        $this->beforeApiCall = $beforeApiCall;

        return $this;
    }

    /**
     * @return \Publikat\Model\Xml\Api\ApiCall
     */
    public function getAfterApiCall()
    {
        return $this->afterApiCall;
    }

    /**
     * @param \Publikat\Model\Xml\Api\ApiCall
     *
     * @return ApiCall
     */
    public function setAfterApiCall($afterApiCall)
    {
        $this->afterApiCall = $afterApiCall;

        return $this;
    }

    public function getId()
    {
        return $this->getMethod();
    }

    public function getLogData()
    {
        return print_r($this, true);
    }
}
