<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Item;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Publikat\Model\Xml\Item\Availability;
use Publikat\Model\Xml\Item\Item;
use Publikat\Model\Xml\Item\Sales30DaysAmazon;

class AvailabilityTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp()
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/availability.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {

        /**
         * @var \Publikat\Model\Xml\Item\ItemTransfer $itemTransferObject
         */
        $itemTransferObject = $this->serializer->deserialize($this->xml, 'Publikat\Model\Xml\Item\ItemTransfer', 'xml');

        /**
         * @var Availability $availabilityObject
         */
        $availabilityObject = $itemTransferObject->getAvailability();

        $this->assertEquals('SO497774', $availabilityObject->getArticleFamilyCode());
        $this->assertEquals('SO49777401', $availabilityObject->getPgc());
        $this->assertEquals(0, $availabilityObject->getIsSoldOut());
        $this->assertEquals(0, $availabilityObject->getRealQty());
        $this->assertEquals('2016-02-26', $availabilityObject->getShippingDate());
        $this->assertEquals('2016-02-25', $availabilityObject->getShippingDateCalculated());
        $this->assertEquals(11, $availabilityObject->getShippingState());
        $this->assertEquals(15344, $availabilityObject->getQuantityOnStock());
        $this->assertEquals(1304, $availabilityObject->getQtyStock());
        $this->assertEquals(2826, $availabilityObject->getQtySalesOrder());
        $this->assertEquals(83, $availabilityObject->getQtySalesOrderQuar());
        $this->assertEquals(13284, $availabilityObject->getQtyPreOrder());
        $this->assertEquals(16949, $availabilityObject->getQtyPurchaseOrder());
        $this->assertEquals(-5, $availabilityObject->getSales90Days());
        $this->assertEquals(-1, $availabilityObject->getSales30Days());
        $this->assertEquals(-2, $availabilityObject->getMinInventory());
        $this->assertEquals(-3, $availabilityObject->getMaxInventory());
        $this->assertEquals(2, $availabilityObject->getIsOrderable());
        $this->assertEquals(1, $availabilityObject->getIsAvailable());
        $this->assertEquals('', $availabilityObject->getPurchaseOrderDate());
        $this->assertEquals(0.2, $availabilityObject->getDynRange1());
        $this->assertEquals(0.4, $availabilityObject->getDynRange2());
        $this->assertEquals(0.8, $availabilityObject->getDynPeriod());
        $this->assertEquals('SU', $availabilityObject->getDyn());
        $this->assertEquals(99, $availabilityObject->getRange30());
        $this->assertEquals(100, $availabilityObject->getRangeB2B30());
        $this->assertEquals(101, $availabilityObject->getRange());
        $this->assertEquals(102, $availabilityObject->getRangeB2B());
        $this->assertEquals(-5, $availabilityObject->getSales90DaysAll());
        $this->assertEquals(-1, $availabilityObject->getSales30DaysAll());
        $this->assertEquals(0, $availabilityObject->getSales60DaysGross());
        $this->assertEquals(23633, $availabilityObject->getSalesTotalGross());
        $this->assertEquals(1, $availabilityObject->getQtyReturns60Days());
        $this->assertEquals(1460, $availabilityObject->getQtyReturnsTotal());
        $this->assertEquals(0, $availabilityObject->getReturnsRate60Days());
        $this->assertEquals(0.06, $availabilityObject->getReturnsRateTotal());

        $this->assertInstanceOf('\Publikat\Model\Xml\Item\Sales30DaysAmazon', $availabilityObject->getSales30DaysAmazon());

        $this->assertEquals(0, $availabilityObject->getSales30DaysWeare());
        $this->assertEquals('Auffüllen auf Maximalbestand', $availabilityObject->getRestockPolicy());
        $this->assertEquals('2016-01-18', $availabilityObject->getLastSale());
        $this->assertEquals('2015-09-14', $availabilityObject->getLastPurchase());
        $this->assertEquals('2015-09-24', $availabilityObject->getAvailabilityDate());
        $this->assertEquals('2016-01-12', $availabilityObject->getDateActive());
        $this->assertEquals(62.94, $availabilityObject->getContributionMarginPercent());

        $this->assertInstanceOf('\Publikat\Model\Xml\Item\Item', $availabilityObject->getItem());
    }

    public function testSetter()
    {

        $availabilityObject = new Availability();

        $itemObject = new Item();
        $sales30DaysAmazon = new Sales30DaysAmazon();

        $availabilityObject->setAvailabilityDate('dummy');
        $availabilityObject->setContributionMarginPercent('dummy');
        $availabilityObject->setDateActive('dummy');
        $availabilityObject->setDyn('dummy');
        $availabilityObject->setDynPeriod('dummy');
        $availabilityObject->setDynRange1('dummy');
        $availabilityObject->setDynRange2('dummy');
        $availabilityObject->setIsAvailable('dummy');
        $availabilityObject->setIsOrderable('dummy');
        $availabilityObject->setIsSoldOut('dummy');
        $availabilityObject->setItem($itemObject);
        $availabilityObject->setLastPurchase('dummy');
        $availabilityObject->setLastSale('dummy');
        $availabilityObject->setMaxInventory('dummy');
        $availabilityObject->setMinInventory('dummy');
        $availabilityObject->setPgc('dummy');
        $availabilityObject->setArticleFamilyCode('dummy');
        $availabilityObject->setPurchaseOrderDate('dummy');
        $availabilityObject->setQtyPreOrder('dummy');
        $availabilityObject->setQtyPurchaseOrder('dummy');
        $availabilityObject->setQtyReturns60Days('dummy');
        $availabilityObject->setQtyReturnsTotal('dummy');
        $availabilityObject->setQtySalesOrder('dummy');
        $availabilityObject->setQtySalesOrderQuar('dummy');
        $availabilityObject->setQtyStock('dummy');
        $availabilityObject->setQuantityOnStock('dummy');
        $availabilityObject->setRange('dummy');
        $availabilityObject->setRange30('dummy');
        $availabilityObject->setRangeB2B('dummy');
        $availabilityObject->setRangeB2B30('dummy');
        $availabilityObject->setRealQty('dummy');
        $availabilityObject->setRestockPolicy('dummy');
        $availabilityObject->setReturnsRate60Days('dummy');
        $availabilityObject->setReturnsRateTotal('dummy');
        $availabilityObject->setSales30Days('dummy');
        $availabilityObject->setSales30DaysAll('dummy');
        $availabilityObject->setSales30DaysAmazon($sales30DaysAmazon);
        $availabilityObject->setSales30DaysWeare('dummy');
        $availabilityObject->setSales60DaysGross('dummy');
        $availabilityObject->setSales90Days('dummy');
        $availabilityObject->setSales90DaysAll('dummy');
        $availabilityObject->setSalesTotalGross('dummy');
        $availabilityObject->setShippingDate('dummy');
        $availabilityObject->setShippingDateCalculated('dummy');
        $availabilityObject->setShippingState('dummy');
        $availabilityObject->setItemCode('dummy');

        $this->assertEquals('dummy', $availabilityObject->getAvailabilityDate());
        $this->assertEquals('dummy', $availabilityObject->getContributionMarginPercent());
        $this->assertEquals('dummy', $availabilityObject->getDateActive());
        $this->assertEquals('dummy', $availabilityObject->getDyn());
        $this->assertEquals('dummy', $availabilityObject->getDynPeriod());
        $this->assertEquals('dummy', $availabilityObject->getDynRange1());
        $this->assertEquals('dummy', $availabilityObject->getDynRange2());
        $this->assertEquals('dummy', $availabilityObject->getIsAvailable());
        $this->assertEquals('dummy', $availabilityObject->getIsOrderable());
        $this->assertEquals('dummy', $availabilityObject->getIsSoldOut());
        $this->assertInstanceOf('\Publikat\Model\Xml\Item\Item', $availabilityObject->getItem());
        $this->assertEquals('dummy', $availabilityObject->getLastPurchase());
        $this->assertEquals('dummy', $availabilityObject->getLastSale());
        $this->assertEquals('dummy', $availabilityObject->getMaxInventory());
        $this->assertEquals('dummy', $availabilityObject->getMinInventory());
        $this->assertEquals('dummy', $availabilityObject->getPgc());
        $this->assertEquals('dummy', $availabilityObject->getArticleFamilyCode());
        $this->assertEquals('dummy', $availabilityObject->getPurchaseOrderDate());
        $this->assertEquals('dummy', $availabilityObject->getQtyPreOrder());
        $this->assertEquals('dummy', $availabilityObject->getQtyPurchaseOrder());
        $this->assertEquals('dummy', $availabilityObject->getQtyReturns60Days());
        $this->assertEquals('dummy', $availabilityObject->getQtyReturnsTotal());
        $this->assertEquals('dummy', $availabilityObject->getQtySalesOrder());
        $this->assertEquals('dummy', $availabilityObject->getQtySalesOrderQuar());
        $this->assertEquals('dummy', $availabilityObject->getQtyStock());
        $this->assertEquals('dummy', $availabilityObject->getQuantityOnStock());
        $this->assertEquals('dummy', $availabilityObject->getRange());
        $this->assertEquals('dummy', $availabilityObject->getRange30());
        $this->assertEquals('dummy', $availabilityObject->getRangeB2B());
        $this->assertEquals('dummy', $availabilityObject->getRangeB2B30());
        $this->assertEquals('dummy', $availabilityObject->getRealQty());
        $this->assertEquals('dummy', $availabilityObject->getRestockPolicy());
        $this->assertEquals('dummy', $availabilityObject->getReturnsRate60Days());
        $this->assertEquals('dummy', $availabilityObject->getReturnsRateTotal());
        $this->assertEquals('dummy', $availabilityObject->getSales30Days());
        $this->assertEquals('dummy', $availabilityObject->getSales30DaysAll());
        $this->assertInstanceOf('\Publikat\Model\Xml\Item\Sales30DaysAmazon', $availabilityObject->getSales30DaysAmazon());
        $this->assertEquals('dummy', $availabilityObject->getSales30DaysWeare());
        $this->assertEquals('dummy', $availabilityObject->getSales60DaysGross());
        $this->assertEquals('dummy', $availabilityObject->getSales90Days());
        $this->assertEquals('dummy', $availabilityObject->getSales90DaysAll());
        $this->assertEquals('dummy', $availabilityObject->getSalesTotalGross());
        $this->assertEquals('dummy', $availabilityObject->getShippingDate());
        $this->assertEquals('dummy', $availabilityObject->getShippingDateCalculated());
        $this->assertEquals('dummy', $availabilityObject->getShippingState());
        $this->assertEquals('dummy', $availabilityObject->getItemCode());
    }
}
