<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\Discount;

use JMS\Serializer\Annotation as Serializer;

/**
 * DiscountPropertiesList
 *
 * @Serializer\XmlRoot("List")
 * @Serializer\ExclusionPolicy("all")
 */
class DiscountPropertiesList
{

    /**
     * @var DiscountProperties[]
     *
     * @Serializer\Expose
     * @Serializer\XmlList(inline = true, entry= "Item")
     * @Serializer\Type("array<Publikat\Model\Xml\Discount\Discount\DiscountProperties>")
     *
     */
    private $items;

    /**
     * @return DiscountProperties[]
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * @param DiscountProperties[] $items
     * @return DiscountPropertiesList
     */
    public function setItems($items)
    {
        $this->items = $items;
        return $this;
    }


}
