<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Item;

use JMS\Serializer\Annotation as Serializer;

/**
 * ItemTransfer
 *
 * @Serializer\XmlRoot("ItemTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class ItemTransfer
{

    /**
     * @var \Publikat\Model\Xml\Item\Availability
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Availability")
     * @Serializer\Type("Publikat\Model\Xml\Item\Availability")
     *
     */
    private $availability;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NavInsertTime")
     * @Serializer\Type("string")
     */
    private $navInsertTime;
    /**
     * @var \Publikat\Model\Xml\Item\ShopData
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShopData")
     * @Serializer\Type("Publikat\Model\Xml\Item\ShopData")
     *
     */
    private $shopData;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     */
    private $transferId;

    /**
     * @return int
     */
    public function getId()
    {

        return $this->transferId;
    }

    /**
     * @return string
     */
    public function getLogData()
    {

        return $this->availability->getPgc() . ': available ' . $this->availability->getIsAvailable() . '; shipping state ' . $this->availability->getShippingState();
    }

    /**
     * @return Availability
     */
    public function getAvailability()
    {

        return $this->availability;
    }

    /**
     * @param Availability $availability
     */
    public function setAvailability($availability)
    {

        $this->availability = $availability;
    }

    /**
     * @return string
     */
    public function getNavInsertTime()
    {

        return $this->navInsertTime;
    }

    /**
     * @param string $navInsertTime
     *
     * @return ItemTransfer
     */
    public function setNavInsertTime($navInsertTime)
    {

        $this->navInsertTime = $navInsertTime;

        return $this;
    }

    /**
     * @return ShopData
     */
    public function getShopData()
    {

        return $this->shopData;
    }

    /**
     * @param ShopData $shopData
     *
     * @return ShopData
     */
    public function setShopData($shopData)
    {

        $this->shopData = $shopData;

        return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {

        return $this->transferId;
    }

    /**
     * @param int $transferId
     */
    public function setTransferId($transferId)
    {

        $this->transferId = $transferId;
    }
}
