<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Item;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Publikat\Model\Xml\Item\ShopData;

class ShopDataTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp()
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/availability.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {

        /**
         * @var \Publikat\Model\Xml\Item\ItemTransfer $itemTransferObject
         */
        $itemTransferObject = $this->serializer->deserialize($this->xml, 'Publikat\Model\Xml\Item\ItemTransfer', 'xml');

        /**
         * @var ShopData $shopDataObject
         */
        $shopDataObject = $itemTransferObject->getShopData();

        $this->assertEquals('2016-05-02', $shopDataObject->getActivationDate());
        $this->assertEquals(666, $shopDataObject->getCategoryId());
        $this->assertEquals('Küchenhelfer', $shopDataObject->getCategoryName());
        $this->assertEquals('12.03.2016 11:53:18<br>10.03.2016 13:59:09<br>03.03.2016 10:55:09<br>03.03.2016 10:49:18<br>18.01.2016 10:36:51', $shopDataObject->getFullUpdate());
        $this->assertEquals('16.03.2016 15:45:29<br>16.03.2016 07:24:15<br>15.03.2016 19:57:08<br>12.03.2016 15:32:16<br>12.03.2016 10:26:22', $shopDataObject->getPartialUpdate());

        $this->assertEquals('AAB4808', $shopDataObject->getArticleFamilyCode());
        $this->assertEquals('Something', $shopDataObject->getArticleName());
        $this->assertEquals('Blue', $shopDataObject->getColor());
        $this->assertEquals(78.45, $shopDataObject->getPrice());
        $this->assertEquals('STF-AMA-DE<br>STF-AMA-FR<br>STF-AMA-IT<br>STF-COM<br>STF-DE<br>STF-ES<br>STF-FR<br>STF-IT<br>STF-NL<br>WEA-AT<br>WEA-DE<br>WEA-FR<br>WEA-NL', $shopDataObject->getShopAssignment());
        $this->assertEquals('F78141', $shopDataObject->getVendorItemNo());
        $this->assertEquals('Material: 52.00% Baumwolle<br>Material: 48.00% Polyester', $shopDataObject->getCareLabeling());
        $this->assertEquals('815', $shopDataObject->getFamilyLinkId());
    }

    public function testSetter()
    {

        $shopDataObject = new ShopData();

        $shopDataObject->setActivationDate('2016-05-02');
        $shopDataObject->setCategoryId(666);
        $shopDataObject->setCategoryName('Küchenhelfer');
        $shopDataObject->setFullUpdate('12.03.2016 11:53:18<br>10.03.2016 13:59:09<br>03.03.2016 10:55:09<br>03.03.2016 10:49:18<br>18.01.2016 10:36:51');
        $shopDataObject->setPartialUpdate('16.03.2016 15:45:29<br>16.03.2016 07:24:15<br>15.03.2016 19:57:08<br>12.03.2016 15:32:16<br>12.03.2016 10:26:22');

        $shopDataObject->setArticleFamilyCode('AAB4808');
        $shopDataObject->setArticleName('Something');
        $shopDataObject->setColor('Blue');
        $shopDataObject->setPrice(78.45);
        $shopDataObject->setShopAssignment('STF-AMA-DE<br>STF-AMA-FR<br>STF-AMA-IT<br>STF-COM<br>STF-DE<br>STF-ES<br>STF-FR<br>STF-IT<br>STF-NL<br>WEA-AT<br>WEA-DE<br>WEA-FR<br>WEA-NL');
        $shopDataObject->setVendorItemNo('F78141');
        $shopDataObject->setCareLabeling('Material: 52.00% Baumwolle<br>Material: 48.00% Polyester');
        $shopDataObject->setFamilyLinkId('815');

        $this->assertEquals('2016-05-02', $shopDataObject->getActivationDate());
        $this->assertEquals(666, $shopDataObject->getCategoryId());
        $this->assertEquals('Küchenhelfer', $shopDataObject->getCategoryName());
        $this->assertEquals('12.03.2016 11:53:18<br>10.03.2016 13:59:09<br>03.03.2016 10:55:09<br>03.03.2016 10:49:18<br>18.01.2016 10:36:51', $shopDataObject->getFullUpdate());
        $this->assertEquals('16.03.2016 15:45:29<br>16.03.2016 07:24:15<br>15.03.2016 19:57:08<br>12.03.2016 15:32:16<br>12.03.2016 10:26:22', $shopDataObject->getPartialUpdate());

        $this->assertEquals('AAB4808', $shopDataObject->getArticleFamilyCode());
        $this->assertEquals('Something', $shopDataObject->getArticleName());
        $this->assertEquals('Blue', $shopDataObject->getColor());
        $this->assertEquals(78.45, $shopDataObject->getPrice());
        $this->assertEquals('STF-AMA-DE<br>STF-AMA-FR<br>STF-AMA-IT<br>STF-COM<br>STF-DE<br>STF-ES<br>STF-FR<br>STF-IT<br>STF-NL<br>WEA-AT<br>WEA-DE<br>WEA-FR<br>WEA-NL', $shopDataObject->getShopAssignment());
        $this->assertEquals('F78141', $shopDataObject->getVendorItemNo());
        $this->assertEquals('Material: 52.00% Baumwolle<br>Material: 48.00% Polyester', $shopDataObject->getCareLabeling());
        $this->assertEquals('815', $shopDataObject->getFamilyLinkId());
    }
}
