<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */
namespace Tests\Publikat\Model\Xml\Item;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Publikat\Model\Xml\Item\Availability;
use Publikat\Model\Xml\Item\ItemTransfer;
use Publikat\Model\Xml\Item\ShopData;

class ItemTransferTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp()
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/test.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {

        /**
         * @var ItemTransfer $itemTransferObject
         */
        $itemTransferObject = $this->serializer->deserialize($this->xml, 'Publikat\Model\Xml\Item\ItemTransfer', 'xml');

        $this->assertEquals(247143, $itemTransferObject->getId());
        $this->assertEquals(247143, $itemTransferObject->getTransferId());
        $this->assertEquals('2016-04-06 15:40:39', $itemTransferObject->getNavInsertTime());

        $this->assertInstanceOf('Publikat\Model\Xml\Item\Availability', $itemTransferObject->getAvailability());
        $this->assertInstanceOf('Publikat\Model\Xml\Item\ShopData', $itemTransferObject->getShopData());

        $this->assertEquals('SO49777401: available 1; shipping state 11', $itemTransferObject->getLogData());
    }

    public function testSetter()
    {

        $itemTransferObject = new ItemTransfer();

        $availabilityObject = new Availability();
        $shopDataObject = new ShopData();

        $itemTransferObject->setAvailability($availabilityObject);
        $itemTransferObject->setNavInsertTime('2016-04-06 15:40:39');
        $itemTransferObject->setShopData($shopDataObject);
        $itemTransferObject->setTransferId('xyz');

        $this->assertInstanceOf('Publikat\Model\Xml\Item\Availability', $itemTransferObject->getAvailability());
        $this->assertEquals('2016-04-06 15:40:39', $itemTransferObject->getNavInsertTime());
        $this->assertInstanceOf('Publikat\Model\Xml\Item\ShopData', $itemTransferObject->getShopData());
        $this->assertEquals('xyz', $itemTransferObject->getTransferId());
    }
}
