<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Customer;

use JMS\Serializer\Annotation as Serializer;

/**
 * Price
 *
 * @Serializer\XmlRoot("Customer")
 * @Serializer\ExclusionPolicy("all")
 */
class Customer
{

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("integer")
     *
     */
    private $id;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CustomerNo")
     * @Serializer\Type("integer")
     *
     */
    private $customerNo;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("SystemId")
     * @Serializer\Type("integer")
     *
     */
    private $systemId;

    /**
     * @var boolean
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("boolean")
     *
     */
    private $delete;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("LanguageToken")
     * @Serializer\Type("string")
     *
     */
    private $languageToken;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameCompany")
     * @Serializer\Type("string")
     *
     */
    private $nameCompany;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameCompany2")
     * @Serializer\Type("string")
     *
     */
    private $nameCompany2;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameFirst")
     * @Serializer\Type("string")
     *
     */
    private $nameFirst;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameLast")
     * @Serializer\Type("string")
     *
     */
    private $nameLast;


    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Gender")
     * @Serializer\Type("integer")
     *
     */
    private $gender;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Street")
     * @Serializer\Type("string")
     *
     */
    private $street;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("StreetNumber")
     * @Serializer\Type("string")
     *
     */
    private $streetNumber;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Zip")
     * @Serializer\Type("integer")
     *
     */
    private $zip;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("City")
     * @Serializer\Type("string")
     *
     */
    private $city;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Phone")
     * @Serializer\Type("string")
     *
     */
    private $phone;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("PhoneMobile")
     * @Serializer\Type("string")
     *
     */
    private $phoneMobile;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Fax")
     * @Serializer\Type("string")
     *
     */
    private $fax;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("VAT")
     * @Serializer\Type("string")
     *
     */
    private $vat;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     *
     */
    private $email;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Password")
     * @Serializer\Type("string")
     *
     */
    private $password;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("OptAddress")
     * @Serializer\Type("string")
     *
     */
    private $optAddress;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IsConform")
     * @Serializer\Type("string")
     *
     */
    private $isConform;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("PaymentTermsId")
     * @Serializer\Type("integer")
     *
     */
    private $paymentTermsId;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CountryId")
     * @Serializer\Type("integer")
     *
     */
    private $countryId;

    /**
     * @var \DateTime
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Birthday")
     * @Serializer\Type("DateTime<'Y-m-d'>")
     *
     */
    private $birthday;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DateCreated")
     * @Serializer\Type("string")
     *
     */
    private $dateCreated;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CustomerType")
     * @Serializer\Type("integer")
     *
     */
    private $customerType;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DiscountGroup")
     * @Serializer\Type("string")
     *
     */
    private $discountGroup;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShopId")
     * @Serializer\Type("string")
     *
     */
    private $shopId;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShopGroup")
     * @Serializer\Type("integer")
     *
     */
    private $shopGroup;

    /**
     * @var CustomerShippingAddress[]
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShippingAddresses")
     * @Serializer\XmlList(inline=false, entry="Item")
     * @Serializer\Type("array<Publikat\Model\Xml\Customer\CustomerShippingAddress>")
     *
     */
    private $shippingAddresses;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return Customer
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int
     */
    public function getCustomerNo()
    {
        return $this->customerNo;
    }

    /**
     * @param int $customerNo
     * @return Customer
     */
    public function setCustomerNo($customerNo)
    {
        $this->customerNo = $customerNo;
        return $this;
    }

    /**
     * @return string
     */
    public function getSystemId()
    {
        return $this->systemId;
    }

    /**
     * @param string $systemId
     * @return Customer
     */
    public function setSystemId($systemId)
    {
        $this->systemId = $systemId;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDelete()
    {
        return $this->delete;
    }

    /**
     * @param bool $delete
     * @return Customer
     */
    public function setDelete($delete)
    {
        $this->delete = $delete;
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageToken()
    {
        return $this->languageToken;
    }

    /**
     * @param string $languageToken
     * @return Customer
     */
    public function setLanguageToken($languageToken)
    {
        $this->languageToken = $languageToken;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameCompany()
    {
        return $this->nameCompany;
    }

    /**
     * @param string $nameCompany
     * @return Customer
     */
    public function setNameCompany($nameCompany)
    {
        $this->nameCompany = $nameCompany;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameCompany2()
    {
        return $this->nameCompany2;
    }

    /**
     * @param string $nameCompany2
     * @return Customer
     */
    public function setNameCompany2($nameCompany2)
    {
        $this->nameCompany2 = $nameCompany2;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameFirst()
    {
        return $this->nameFirst;
    }

    /**
     * @param string $nameFirst
     * @return Customer
     */
    public function setNameFirst($nameFirst)
    {
        $this->nameFirst = $nameFirst;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameLast()
    {
        return $this->nameLast;
    }

    /**
     * @param string $nameLast
     * @return Customer
     */
    public function setNameLast($nameLast)
    {
        $this->nameLast = $nameLast;
        return $this;
    }

    /**
     * @return int
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * @param int $gender
     * @return Customer
     */
    public function setGender($gender)
    {
        $this->gender = $gender;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @param string $street
     * @return Customer
     */
    public function setStreet($street)
    {
        $this->street = $street;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }

    /**
     * @param string $streetNumber
     * @return Customer
     */
    public function setStreetNumber($streetNumber)
    {
        $this->streetNumber = $streetNumber;
        return $this;
    }

    /**
     * @return int
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * @param int $zip
     * @return Customer
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
        return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $city
     * @return Customer
     */
    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     * @return Customer
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhoneMobile()
    {
        return $this->phoneMobile;
    }

    /**
     * @param string $phoneMobile
     * @return Customer
     */
    public function setPhoneMobile($phoneMobile)
    {
        $this->phoneMobile = $phoneMobile;
        return $this;
    }

    /**
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * @param string $fax
     * @return Customer
     */
    public function setFax($fax)
    {
        $this->fax = $fax;
        return $this;
    }

    /**
     * @return string
     */
    public function getVat()
    {
        return $this->vat;
    }

    /**
     * @param string $vat
     * @return Customer
     */
    public function setVat($vat)
    {
        $this->vat = $vat;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return Customer
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return Customer
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @return string
     */
    public function getOptAddress()
    {
        return $this->optAddress;
    }

    /**
     * @param string $optAddress
     * @return Customer
     */
    public function setOptAddress($optAddress)
    {
        $this->optAddress = $optAddress;
        return $this;
    }

    /**
     * @return string
     */
    public function getisConform()
    {
        return $this->isConform;
    }

    /**
     * @param string $isConform
     * @return Customer
     */
    public function setIsConform($isConform)
    {
        $this->isConform = $isConform;
        return $this;
    }

    /**
     * @return int
     */
    public function getPaymentTermsId()
    {
        return $this->paymentTermsId;
    }

    /**
     * @param int $paymentTermsId
     * @return Customer
     */
    public function setPaymentTermsId($paymentTermsId)
    {
        $this->paymentTermsId = $paymentTermsId;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountryId()
    {
        return $this->countryId;
    }

    /**
     * @param int $countryId
     * @return Customer
     */
    public function setCountryId($countryId)
    {
        $this->countryId = $countryId;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBirthday()
    {
        return $this->birthday;
    }

    /**
     * @param \DateTime $birthday
     * @return Customer
     */
    public function setBirthday($birthday)
    {
        $this->birthday = $birthday;
        return $this;
    }

    /**
     * @return string
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param string $dateCreated
     * @return Customer
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }

    /**
     * @return int
     */
    public function getCustomerType()
    {
        return $this->customerType;
    }

    /**
     * @param int $customerType
     * @return Customer
     */
    public function setCustomerType($customerType)
    {
        $this->customerType = $customerType;
        return $this;
    }

    /**
     * @return string
     */
    public function getShopId()
    {
        return $this->shopId;
    }

    /**
     * @param string $shopId
     * @return Customer
     */
    public function setShopId($shopId)
    {
        $this->shopId = $shopId;
        return $this;
    }

    /**
     * @return int
     */
    public function getShopGroup()
    {
        return $this->shopGroup;
    }

    /**
     * @param int $shopGroup
     * @return Customer
     */
    public function setShopGroup($shopGroup)
    {
        $this->shopGroup = $shopGroup;
        return $this;
    }

    /**
     * @return CustomerShippingAddress[]
     */
    public function getShippingAddresses()
    {
        return $this->shippingAddresses;
    }

    /**
     * @param CustomerShippingAddress[] $shippingAddresses
     * @return Customer
     */
    public function setShippingAddresses($shippingAddresses)
    {
        $this->shippingAddresses = $shippingAddresses;
        return $this;
    }

    /**
     * @return string
     */
    public function getDiscountGroup()
    {
        return $this->discountGroup;
    }

    /**
     * @param string $discountGroup
     * @return Customer
     */
    public function setDiscountGroup($discountGroup)
    {
        $this->discountGroup = $discountGroup;
        return $this;
    }


}
