<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Customer;

use JMS\Serializer\Annotation as Serializer;

/**
 * Price
 *
 * @Serializer\XmlRoot("Item")
 */
class CustomerShippingAddress
{

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("integer")
     *
     */
    private $id;


    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameCompany")
     * @Serializer\Type("string")
     *
     */
    private $nameCompany;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameCompany2")
     * @Serializer\Type("string")
     *
     */
    private $nameCompany2;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameFirst")
     * @Serializer\Type("string")
     *
     */
    private $nameFirst;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NameLast")
     * @Serializer\Type("string")
     *
     */
    private $nameLast;


    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Street")
     * @Serializer\Type("string")
     *
     */
    private $street;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("StreetNumber")
     * @Serializer\Type("string")
     *
     */
    private $streetNumber;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Zip")
     * @Serializer\Type("integer")
     *
     */
    private $zip;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("City")
     * @Serializer\Type("string")
     *
     */
    private $city;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("OptAddress")
     * @Serializer\Type("string")
     *
     */
    private $optAddress;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IsConform")
     * @Serializer\Type("string")
     *
     */
    private $isConform;


    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CountryId")
     * @Serializer\Type("integer")
     *
     */
    private $countryId;


    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DateCreated")
     * @Serializer\Type("string")
     *
     */
    private $dateCreated;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("integer")
     *
     */
    private $type;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return CustomerShippingAddress
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameCompany()
    {
        return $this->nameCompany;
    }

    /**
     * @param string $nameCompany
     * @return CustomerShippingAddress
     */
    public function setNameCompany($nameCompany)
    {
        $this->nameCompany = $nameCompany;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameCompany2()
    {
        return $this->nameCompany2;
    }

    /**
     * @param string $nameCompany2
     * @return CustomerShippingAddress
     */
    public function setNameCompany2($nameCompany2)
    {
        $this->nameCompany2 = $nameCompany2;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameFirst()
    {
        return $this->nameFirst;
    }

    /**
     * @param string $nameFirst
     * @return CustomerShippingAddress
     */
    public function setNameFirst($nameFirst)
    {
        $this->nameFirst = $nameFirst;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameLast()
    {
        return $this->nameLast;
    }

    /**
     * @param string $nameLast
     * @return CustomerShippingAddress
     */
    public function setNameLast($nameLast)
    {
        $this->nameLast = $nameLast;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @param string $street
     * @return CustomerShippingAddress
     */
    public function setStreet($street)
    {
        $this->street = $street;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }

    /**
     * @param string $streetNumber
     * @return CustomerShippingAddress
     */
    public function setStreetNumber($streetNumber)
    {
        $this->streetNumber = $streetNumber;
        return $this;
    }

    /**
     * @return int
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * @param int $zip
     * @return CustomerShippingAddress
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
        return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $city
     * @return CustomerShippingAddress
     */
    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return string
     */
    public function getOptAddress()
    {
        return $this->optAddress;
    }

    /**
     * @param string $optAddress
     * @return CustomerShippingAddress
     */
    public function setOptAddress($optAddress)
    {
        $this->optAddress = $optAddress;
        return $this;
    }

    /**
     * @return string
     */
    public function getisConform()
    {
        return $this->isConform;
    }

    /**
     * @param string $isConform
     * @return CustomerShippingAddress
     */
    public function setIsConform($isConform)
    {
        $this->isConform = $isConform;
        return $this;
    }

    /**
     * @return int
     */
    public function getCountryId()
    {
        return $this->countryId;
    }

    /**
     * @param int $countryId
     * @return CustomerShippingAddress
     */
    public function setCountryId($countryId)
    {
        $this->countryId = $countryId;
        return $this;
    }

    /**
     * @return string
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param string $dateCreated
     * @return CustomerShippingAddress
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }

    /**
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param int $type
     * @return CustomerShippingAddress
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

}
