<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Family\Relation;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ModelInterface;

/**
 * FamilyRelationTransfer
 *
 * @Serializer\XmlRoot("FamilyRelationTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class FamilyRelationTransfer implements ModelInterface
{

    /**
     * @var \Publikat\Model\Xml\Family\Relation\FamilyRelation
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("FamilyRelation")
     * @Serializer\Type("Publikat\Model\Xml\Family\Relation\FamilyRelation")
     *
     */
    private $familyRelation;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NavInsertTime")
     * @Serializer\Type("string")
     */
    private $navInsertTime;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     */
    private $transferId;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->getFamilyRelation()->getFamilyId();
    }

    /**
     * @return string
     */
    public function getLogData()
    {
        return print_r($this, true);
    }

    /**
     * @return FamilyRelation
     */
    public function getFamilyRelation()
    {
        return $this->familyRelation;
    }

    /**
     * @param FamilyRelation $familyRelation
     *
     * @return FamilyRelationTransfer
     */
    public function setFamilyRelation($familyRelation)
    {
        $this->familyRelation = $familyRelation;

        return $this;
    }

    /**
     * @return string
     */
    public function getNavInsertTime()
    {
        return $this->navInsertTime;
    }

    /**
     * @param string $navInsertTime
     *
     * @return FamilyRelationTransfer
     */
    public function setNavInsertTime($navInsertTime)
    {
        $this->navInsertTime = $navInsertTime;

        return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {
        return $this->transferId;
    }

    /**
     * @param int $transferId
     *
     * @return FamilyRelationTransfer
     */
    public function setTransferId($transferId)
    {
        $this->transferId = $transferId;

        return $this;
    }

}
