<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Api;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Publikat\Model\Xml\Api\ApiCall;
use Publikat\Model\Xml\ItemList;

class ApiCallTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp()
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/apiCall.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {
        /**
         * @var $apiCallObject ApiCall
         */
        $apiCallObject = $this->serializer->deserialize($this->xml,
            'Publikat\Model\Xml\Api\ApiCall',
            'xml');

        //$this->assertNotNull($customerTransferObject->getNavInsertTime());
        $this->iterateAndAssertGetter($apiCallObject);
        $this->assertEquals('Userxml:Pass123f', $apiCallObject->getAuthentication());
        $this->assertNotEmpty($apiCallObject->getParameterList()->getItems());
        $this->assertNotEmpty($apiCallObject->getAfterApiCall()->getParameterList()->getItems());
        $this->assertNotEmpty($apiCallObject->getBeforeApiCall()->getParameterList()->getItems());
    }

    public function testSerialize()
    {

        $apiCall = new ApiCall();

        $apiCall->setMethod('test123');
        $apiCall->setAuthentication("test:123");

        $parameter = new ItemList();
        $parameter->setItems(['test', 'test2', 'test3']);
        $apiCall->setParameterList($parameter);

        $apiCallAfter = clone $apiCall;
        $apiCallBefore = clone $apiCall;

        $apiCall->setAfterApiCall($apiCallAfter);
        $apiCall->setBeforeApiCall($apiCallBefore);

        $xml = $this->serializer->serialize($apiCall, 'xml');
        $this->assertContains('test3', $xml);
    }

    /**
     * @param $objectToTest
     */
    private function iterateAndAssertGetter($objectToTest)
    {
        foreach (get_class_methods(get_class($objectToTest)) as $method) {
            if (strpos($method, 'set') === false) {
                $getterValue = $objectToTest->{$method}();
                $this->assertNotNull($getterValue);
            }
        }
    }

}
