<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\CustomerDiscountGroup;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ModelInterface;

/**
 * CustomerDiscountGroupTransfer
 *
 * @Serializer\XmlRoot("CustomerDiscountGroupTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class CustomerDiscountGroupTransfer implements ModelInterface
{

    /**
     * @var CustomerDiscountGroup
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CustomerDiscountGroup")
     * @Serializer\Type("Publikat\Model\Xml\Discount\CustomerDiscountGroup\CustomerDiscountGroup")
     *
     */
    private $customerDiscountGroup;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NavInsertTime")
     * @Serializer\Type("string")
     */
    private $navInsertTime;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     */
    private $transferId;

    /**
     * @return int
     */
    public function getId()
    {

        return $this->getCustomerDiscountGroup()->getCustomerId();
    }

    /**
     * @return string
     */
    public function getLogData()
    {

        return print_r($this, true);
    }

    /**
     * @return CustomerDiscountGroup
     */
    public function getCustomerDiscountGroup()
    {
        return $this->customerDiscountGroup;
    }

    /**
     * @param CustomerDiscountGroup $customerDiscountGroup
     * @return ProductDiscountGroupTransfer
     */
    public function setCustomerDiscountGroup($customerDiscountGroup)
    {
        $this->customerDiscountGroup = $customerDiscountGroup;
        return $this;
    }

    /**
     * @return string
     */
    public function getNavInsertTime()
    {
        return $this->navInsertTime;
    }

    /**
     * @param string $navInsertTime
     * @return DiscountTransfer
     */
    public function setNavInsertTime($navInsertTime)
    {
        $this->navInsertTime = $navInsertTime;
        return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {
        return $this->transferId;
    }

    /**
     * @param int $transferId
     * @return DiscountTransfer
     */
    public function setTransferId($transferId)
    {
        $this->transferId = $transferId;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getLogFileName()
    {
        return $this->getId();
    }
}
