<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Item;

use JMS\Serializer\Annotation as Serializer;

/**
 * Availability
 *
 * @Serializer\XmlRoot("Availability")
 * @Serializer\ExclusionPolicy("all")
 */
class Availability
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("AvailabilityDate")
     * @Serializer\Type("string")
     *
     */
    private $availabilityDate;

    /**
     * @var double
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ContributionMarginPercent")
     * @Serializer\Type("double")
     *
     */
    private $contributionMarginPercent;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DateActive")
     * @Serializer\Type("string")
     *
     */
    private $dateActive;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Dyn")
     * @Serializer\Type("string")
     *
     */
    private $dyn;

    /**
     * @var float
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DynPeriod")
     * @Serializer\Type("double")
     *
     */
    private $dynPeriod;

    /**
     * @var float
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DynRange1")
     * @Serializer\Type("double")
     *
     */
    private $dynRange1;

    /**
     * @var float
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DynRange2")
     * @Serializer\Type("double")
     *
     */
    private $dynRange2;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IsAvailable")
     * @Serializer\Type("integer")
     *
     */
    private $isAvailable;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IsOrderable")
     * @Serializer\Type("integer")
     *
     */
    private $isOrderable;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IsSoldOut")
     * @Serializer\Type("integer")
     *
     */
    private $isSoldOut;

    /**
     * @var \Publikat\Model\Xml\Item\Item
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Item")
     * @Serializer\Type("Publikat\Model\Xml\Item\Item")
     *
     */
    private $item;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("LastPurchase")
     * @Serializer\Type("string")
     *
     */
    private $lastPurchase;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("LastSale")
     * @Serializer\Type("string")
     *
     */
    private $lastSale;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("MaxInventory")
     * @Serializer\Type("integer")
     *
     */
    private $maxInventory;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("MinInventory")
     * @Serializer\Type("integer")
     *
     */
    private $minInventory;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ItemCode")
     * @Serializer\Type("string")
     *
     */
    private $itemCode;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ProductGroupCode")
     * @Serializer\Type("string")
     *
     */
    private $pgc;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ArticleFamilyCode")
     * @Serializer\Type("string")
     *
     */
    private $articleFamilyCode;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("PurchaseOrderDate")
     * @Serializer\Type("string")
     *
     */
    private $purchaseOrderDate;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyPreOrder")
     * @Serializer\Type("integer")
     *
     */
    private $qtyPreOrder;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyPurchaseOrder")
     * @Serializer\Type("integer")
     *
     */
    private $qtyPurchaseOrder;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyReturns60Days")
     * @Serializer\Type("integer")
     *
     */
    private $qtyReturns60Days;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyReturnsTotal")
     * @Serializer\Type("integer")
     *
     */
    private $qtyReturnsTotal;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtySalesOrder")
     * @Serializer\Type("integer")
     *
     */
    private $qtySalesOrder;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtySalesOrderQuar")
     * @Serializer\Type("integer")
     *
     */
    private $qtySalesOrderQuar;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyStock")
     * @Serializer\Type("integer")
     *
     */
    private $qtyStock;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QuantityOnStock")
     * @Serializer\Type("integer")
     *
     */
    private $quantityOnStock;

    /**
     * @var double
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Range")
     * @Serializer\Type("double")
     *
     */
    private $range;

    /**
     * @var double
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Range30")
     * @Serializer\Type("double")
     *
     */
    private $range30;

    /**
     * @var double
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RangeB2B")
     * @Serializer\Type("double")
     *
     */
    private $rangeB2B;

    /**
     * @var double
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RangeB2B30")
     * @Serializer\Type("double")
     *
     */
    private $rangeB2B30;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RealQty")
     * @Serializer\Type("integer")
     *
     */
    private $realQty;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RestockPolicy")
     * @Serializer\Type("string")
     *
     */
    private $restockPolicy;
    /**
     * @var double
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ReturnsRate60Days")
     * @Serializer\Type("double")
     *
     */
    private $returnsRate60Days;
    /**
     * @var double
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ReturnsRateTotal")
     * @Serializer\Type("double")
     *
     */
    private $returnsRateTotal;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30Days")
     * @Serializer\Type("integer")
     *
     */
    private $sales30Days;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30DaysAll")
     * @Serializer\Type("integer")
     *
     */
    private $sales30DaysAll;

    /**
     * @var \Publikat\Model\Xml\Item\Sales30DaysAmazon
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30DaysAmazon")
     * @Serializer\Type("Publikat\Model\Xml\Item\Sales30DaysAmazon")
     *
     */
    private $sales30DaysAmazon;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30DaysWeare")
     * @Serializer\Type("integer")
     */
    private $sales30DaysWeare;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales60DaysGross")
     * @Serializer\Type("integer")
     *
     */
    private $sales60DaysGross;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales90Days")
     * @Serializer\Type("integer")
     *
     */
    private $sales90Days;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales90DaysAll")
     * @Serializer\Type("integer")
     *
     */
    private $sales90DaysAll;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("SalesTotalGross")
     * @Serializer\Type("integer")
     *
     */
    private $salesTotalGross;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShippingDate")
     * @Serializer\Type("string")
     *
     */
    private $shippingDate;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShippingDateCalculated")
     * @Serializer\Type("string")
     *
     */
    private $shippingDateCalculated;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShippingState")
     * @Serializer\Type("integer")
     *
     */
    private $shippingState;

    /**
     * @return string
     */
    public function getAvailabilityDate()
    {

        return $this->availabilityDate;
    }

    /**
     * @param string $availabilityDate
     *
     * @return Availability
     */
    public function setAvailabilityDate($availabilityDate)
    {

        $this->availabilityDate = $availabilityDate;

        return $this;
    }

    /**
     * @return float
     */
    public function getContributionMarginPercent()
    {

        return $this->contributionMarginPercent;
    }

    /**
     * @param float $contributionMarginPercent
     *
     * @return Availability
     */
    public function setContributionMarginPercent($contributionMarginPercent)
    {

        $this->contributionMarginPercent = $contributionMarginPercent;

        return $this;
    }

    /**
     * @return string
     */
    public function getDateActive()
    {

        return $this->dateActive;
    }

    /**
     * @param string $dateActive
     *
     * @return Availability
     */
    public function setDateActive($dateActive)
    {

        $this->dateActive = $dateActive;

        return $this;
    }

    /**
     * @return string
     */
    public function getDyn()
    {

        return $this->dyn;
    }

    /**
     * @param string $dyn
     *
     * @return Availability
     */
    public function setDyn($dyn)
    {

        $this->dyn = $dyn;

        return $this;
    }

    /**
     * @return int
     */
    public function getDynPeriod()
    {

        return $this->dynPeriod;
    }

    /**
     * @param int $dynPeriod
     *
     * @return Availability
     */
    public function setDynPeriod($dynPeriod)
    {

        $this->dynPeriod = $dynPeriod;

        return $this;
    }

    /**
     * @return float
     */
    public function getDynRange1()
    {

        return $this->dynRange1;
    }

    /**
     * @param float $dynRange1
     *
     * @return Availability
     */
    public function setDynRange1($dynRange1)
    {

        $this->dynRange1 = $dynRange1;

        return $this;
    }

    /**
     * @return float
     */
    public function getDynRange2()
    {

        return $this->dynRange2;
    }

    /**
     * @param float $dynRange2
     *
     * @return Availability
     */
    public function setDynRange2($dynRange2)
    {

        $this->dynRange2 = $dynRange2;

        return $this;
    }

    /**
     * @return int
     */
    public function getIsAvailable()
    {

        return $this->isAvailable;
    }

    /**
     * @param int $isAvailable
     *
     * @return Availability
     */
    public function setIsAvailable($isAvailable)
    {

        $this->isAvailable = $isAvailable;

        return $this;
    }

    /**
     * @return int
     */
    public function getIsOrderable()
    {

        return $this->isOrderable;
    }

    /**
     * @param int $isOrderable
     *
     * @return Availability
     */
    public function setIsOrderable($isOrderable)
    {

        $this->isOrderable = $isOrderable;

        return $this;
    }

    /**
     * @return int
     */
    public function getIsSoldOut()
    {

        return $this->isSoldOut;
    }

    /**
     * @param int $isSoldOut
     *
     * @return Availability
     */
    public function setIsSoldOut($isSoldOut)
    {

        $this->isSoldOut = $isSoldOut;

        return $this;
    }

    /**
     * @return Item
     */
    public function getItem()
    {

        return $this->item;
    }

    /**
     * @param Item $item
     *
     * @return Availability
     */
    public function setItem($item)
    {

        $this->item = $item;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastPurchase()
    {

        return $this->lastPurchase;
    }

    /**
     * @param string $lastPurchase
     *
     * @return Availability
     */
    public function setLastPurchase($lastPurchase)
    {

        $this->lastPurchase = $lastPurchase;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastSale()
    {

        return $this->lastSale;
    }

    /**
     * @param string $lastSale
     *
     * @return Availability
     */
    public function setLastSale($lastSale)
    {

        $this->lastSale = $lastSale;

        return $this;
    }

    /**
     * @return int
     */
    public function getMaxInventory()
    {

        return $this->maxInventory;
    }

    /**
     * @param int $maxInventory
     *
     * @return Availability
     */
    public function setMaxInventory($maxInventory)
    {

        $this->maxInventory = $maxInventory;

        return $this;
    }

    /**
     * @return int
     */
    public function getMinInventory()
    {

        return $this->minInventory;
    }

    /**
     * @param int $minInventory
     *
     * @return Availability
     */
    public function setMinInventory($minInventory)
    {

        $this->minInventory = $minInventory;

        return $this;
    }

    /**
     * @return string
     */
    public function getPgc()
    {

        return $this->pgc;
    }

    /**
     * @param string $pgc
     *
     * @return Availability
     */
    public function setPgc($pgc)
    {

        $this->pgc = $pgc;

        return $this;
    }

    /**
     * @return string
     */
    public function getArticleFamilyCode()
    {
        return $this->articleFamilyCode;
    }

    /**
     * @param string $articleFamilyCode
     * @return Availability
     */
    public function setArticleFamilyCode($articleFamilyCode)
    {
        $this->articleFamilyCode = $articleFamilyCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderDate()
    {

        return $this->purchaseOrderDate;
    }

    /**
     * @param string $purchaseOrderDate
     *
     * @return Availability
     */
    public function setPurchaseOrderDate($purchaseOrderDate)
    {

        $this->purchaseOrderDate = $purchaseOrderDate;

        return $this;
    }

    /**
     * @return int
     */
    public function getQtyPreOrder()
    {

        return $this->qtyPreOrder;
    }

    /**
     * @param int $qtyPreOrder
     *
     * @return Availability
     */
    public function setQtyPreOrder($qtyPreOrder)
    {

        $this->qtyPreOrder = $qtyPreOrder;

        return $this;
    }

    /**
     * @return int
     */
    public function getQtyPurchaseOrder()
    {

        return $this->qtyPurchaseOrder;
    }

    /**
     * @param int $qtyPurchaseOrder
     *
     * @return Availability
     */
    public function setQtyPurchaseOrder($qtyPurchaseOrder)
    {

        $this->qtyPurchaseOrder = $qtyPurchaseOrder;

        return $this;
    }

    /**
     * @return int
     */
    public function getQtyReturns60Days()
    {

        return $this->qtyReturns60Days;
    }

    /**
     * @param int $qtyReturns60Days
     *
     * @return Availability
     */
    public function setQtyReturns60Days($qtyReturns60Days)
    {

        $this->qtyReturns60Days = $qtyReturns60Days;

        return $this;
    }

    /**
     * @return int
     */
    public function getQtyReturnsTotal()
    {

        return $this->qtyReturnsTotal;
    }

    /**
     * @param int $qtyReturnsTotal
     *
     * @return Availability
     */
    public function setQtyReturnsTotal($qtyReturnsTotal)
    {

        $this->qtyReturnsTotal = $qtyReturnsTotal;

        return $this;
    }

    /**
     * @return int
     */
    public function getQtySalesOrder()
    {

        return $this->qtySalesOrder;
    }

    /**
     * @param int $qtySalesOrder
     *
     * @return Availability
     */
    public function setQtySalesOrder($qtySalesOrder)
    {

        $this->qtySalesOrder = $qtySalesOrder;

        return $this;
    }

    /**
     * @return int
     */
    public function getQtySalesOrderQuar()
    {

        return $this->qtySalesOrderQuar;
    }

    /**
     * @param int $qtySalesOrderQuar
     *
     * @return Availability
     */
    public function setQtySalesOrderQuar($qtySalesOrderQuar)
    {

        $this->qtySalesOrderQuar = $qtySalesOrderQuar;

        return $this;
    }

    /**
     * @return int
     */
    public function getQtyStock()
    {

        return $this->qtyStock;
    }

    /**
     * @param int $qtyStock
     *
     * @return Availability
     */
    public function setQtyStock($qtyStock)
    {

        $this->qtyStock = $qtyStock;

        return $this;
    }

    /**
     * @return int
     */
    public function getQuantityOnStock()
    {

        return $this->quantityOnStock;
    }

    /**
     * @param int $quantityOnStock
     *
     * @return Availability
     */
    public function setQuantityOnStock($quantityOnStock)
    {

        $this->quantityOnStock = $quantityOnStock;

        return $this;
    }

    /**
     * @return float
     */
    public function getRange()
    {

        return $this->range;
    }

    /**
     * @param float $range
     *
     * @return Availability
     */
    public function setRange($range)
    {

        $this->range = $range;

        return $this;
    }

    /**
     * @return float
     */
    public function getRange30()
    {

        return $this->range30;
    }

    /**
     * @param float $range30
     *
     * @return Availability
     */
    public function setRange30($range30)
    {

        $this->range30 = $range30;

        return $this;
    }

    /**
     * @return float
     */
    public function getRangeB2B()
    {

        return $this->rangeB2B;
    }

    /**
     * @param float $rangeB2B
     *
     * @return Availability
     */
    public function setRangeB2B($rangeB2B)
    {

        $this->rangeB2B = $rangeB2B;

        return $this;
    }

    /**
     * @return float
     */
    public function getRangeB2B30()
    {

        return $this->rangeB2B30;
    }

    /**
     * @param float $rangeB2B30
     *
     * @return Availability
     */
    public function setRangeB2B30($rangeB2B30)
    {

        $this->rangeB2B30 = $rangeB2B30;

        return $this;
    }

    /**
     * @return int
     */
    public function getRealQty()
    {

        return $this->realQty;
    }

    /**
     * @param int $realQty
     *
     * @return Availability
     */
    public function setRealQty($realQty)
    {

        $this->realQty = $realQty;

        return $this;
    }

    /**
     * @return string
     */
    public function getRestockPolicy()
    {

        return $this->restockPolicy;
    }

    /**
     * @param string $restockPolicy
     *
     * @return Availability
     */
    public function setRestockPolicy($restockPolicy)
    {

        $this->restockPolicy = $restockPolicy;

        return $this;
    }

    /**
     * @return float
     */
    public function getReturnsRate60Days()
    {

        return $this->returnsRate60Days;
    }

    /**
     * @param float $returnsRate60Days
     *
     * @return Availability
     */
    public function setReturnsRate60Days($returnsRate60Days)
    {

        $this->returnsRate60Days = $returnsRate60Days;

        return $this;
    }

    /**
     * @return float
     */
    public function getReturnsRateTotal()
    {

        return $this->returnsRateTotal;
    }

    /**
     * @param float $returnsRateTotal
     *
     * @return Availability
     */
    public function setReturnsRateTotal($returnsRateTotal)
    {

        $this->returnsRateTotal = $returnsRateTotal;

        return $this;
    }

    /**
     * @return int
     */
    public function getSales30Days()
    {

        return $this->sales30Days;
    }

    /**
     * @param int $sales30Days
     *
     * @return Availability
     */
    public function setSales30Days($sales30Days)
    {

        $this->sales30Days = $sales30Days;

        return $this;
    }

    /**
     * @return int
     */
    public function getSales30DaysAll()
    {

        return $this->sales30DaysAll;
    }

    /**
     * @param int $sales30DaysAll
     *
     * @return Availability
     */
    public function setSales30DaysAll($sales30DaysAll)
    {

        $this->sales30DaysAll = $sales30DaysAll;

        return $this;
    }

    /**
     * @return Sales30DaysAmazon
     */
    public function getSales30DaysAmazon()
    {

        return $this->sales30DaysAmazon;
    }

    /**
     * @param Sales30DaysAmazon $sales30DaysAmazon
     *
     * @return Availability
     */
    public function setSales30DaysAmazon($sales30DaysAmazon)
    {

        $this->sales30DaysAmazon = $sales30DaysAmazon;

        return $this;
    }

    /**
     * @return int
     */
    public function getSales30DaysWeare()
    {

        return $this->sales30DaysWeare;
    }

    /**
     * @param int $sales30DaysWeare
     *
     * @return Availability
     */
    public function setSales30DaysWeare($sales30DaysWeare)
    {

        $this->sales30DaysWeare = $sales30DaysWeare;

        return $this;
    }

    /**
     * @return int
     */
    public function getSales60DaysGross()
    {

        return $this->sales60DaysGross;
    }

    /**
     * @param int $sales60DaysGross
     *
     * @return Availability
     */
    public function setSales60DaysGross($sales60DaysGross)
    {

        $this->sales60DaysGross = $sales60DaysGross;

        return $this;
    }

    /**
     * @return int
     */
    public function getSales90Days()
    {

        return $this->sales90Days;
    }

    /**
     * @param int $sales90Days
     *
     * @return Availability
     */
    public function setSales90Days($sales90Days)
    {

        $this->sales90Days = $sales90Days;

        return $this;
    }

    /**
     * @return int
     */
    public function getSales90DaysAll()
    {

        return $this->sales90DaysAll;
    }

    /**
     * @param int $sales90DaysAll
     *
     * @return Availability
     */
    public function setSales90DaysAll($sales90DaysAll)
    {

        $this->sales90DaysAll = $sales90DaysAll;

        return $this;
    }

    /**
     * @return int
     */
    public function getSalesTotalGross()
    {

        return $this->salesTotalGross;
    }

    /**
     * @param int $salesTotalGross
     *
     * @return Availability
     */
    public function setSalesTotalGross($salesTotalGross)
    {

        $this->salesTotalGross = $salesTotalGross;

        return $this;
    }

    /**
     * @return string
     */
    public function getShippingDate()
    {

        return $this->shippingDate;
    }

    /**
     * @param string $shippingDate
     *
     * @return Availability
     */
    public function setShippingDate($shippingDate)
    {
        $this->shippingDate = $shippingDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getShippingDateCalculated()
    {
        return $this->shippingDateCalculated;
    }

    /**
     * @param string $shippingDateCalculated
     *
     * @return Availability
     */
    public function setShippingDateCalculated($shippingDateCalculated)
    {
        $this->shippingDateCalculated = $shippingDateCalculated;
        return $this;
    }

    /**
     * @return int
     */
    public function getShippingState()
    {
        return $this->shippingState;
    }

    /**
     * @param int $shippingState
     *
     * @return Availability
     */
    public function setShippingState($shippingState)
    {
        $this->shippingState = $shippingState;
        return $this;
    }

    /**
     * @return string
     */
    public function getItemCode()
    {
        return $this->itemCode;
    }

    /**
     * @param string $itemCode
     * @return Availability
     */
    public function setItemCode($itemCode)
    {
        $this->itemCode = $itemCode;
        return $this;
    }
}
