<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Item;

use JMS\Serializer\Annotation as Serializer;

/**
 * ShopData
 *
 * @Serializer\XmlRoot("ShopData")
 * @Serializer\ExclusionPolicy("all")
 */
class ShopData
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ActivationDate")
     * @Serializer\Type("string")
     */
    private $activationDate;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ArticleFamilyCode")
     * @Serializer\Type("string")
     */
    private $articleFamilyCode;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ArticleName")
     * @Serializer\Type("string")
     */
    private $articleName;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CareLabeling")
     * @Serializer\Type("string")
     */
    private $careLabeling;
    /**
     * @var int
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CategoryId")
     * @Serializer\Type("integer")
     */
    private $categoryId;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CategoryName")
     * @Serializer\Type("string")
     */
    private $categoryName;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CategoryFolder")
     * @Serializer\Type("string")
     */
    private $categoryFolder;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Color")
     * @Serializer\Type("string")
     */
    private $color;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("FamilyLinkId")
     * @Serializer\Type("string")
     */
    private $familyLinkId;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("FullUpdate")
     * @Serializer\Type("string")
     */
    private $fullUpdate;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("PartialUpdate")
     * @Serializer\Type("string")
     */
    private $partialUpdate;

    /**
     * @var float
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Price")
     * @Serializer\Type("double")
     */
    private $price;

    /**
     * @var float
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("PriceUvp")
     * @Serializer\Type("double")
     */
    private $priceUvp;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShopAssignment")
     * @Serializer\Type("string")
     */
    private $shopAssignment;
    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("VendorItemNo")
     * @Serializer\Type("string")
     */
    private $vendorItemNo;

    /**
     * @return string
     */
    public function getActivationDate()
    {

        return $this->activationDate;
    }

    /**
     * @param string $activationDate
     *
     * @return ShopData
     */
    public function setActivationDate($activationDate)
    {

        $this->activationDate = $activationDate;

        return $this;
    }

    /**
     * @return string
     */
    public function getArticleFamilyCode()
    {

        return $this->articleFamilyCode;
    }

    /**
     * @param string $articleFamilyCode
     *
     * @return ShopData
     */
    public function setArticleFamilyCode($articleFamilyCode)
    {

        $this->articleFamilyCode = $articleFamilyCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getArticleName()
    {

        return $this->articleName;
    }

    /**
     * @param string $articleName
     *
     * @return ShopData
     */
    public function setArticleName($articleName)
    {

        $this->articleName = $articleName;

        return $this;
    }

    /**
     * @return string
     */
    public function getCareLabeling()
    {

        return $this->careLabeling;
    }

    /**
     * @param string $careLabeling
     *
     * @return ShopData
     */
    public function setCareLabeling($careLabeling)
    {

        $this->careLabeling = $careLabeling;

        return $this;
    }

    /**
     * @return int
     */
    public function getCategoryId()
    {

        return $this->categoryId;
    }

    /**
     * @param int $categoryId
     *
     * @return ShopData
     */
    public function setCategoryId($categoryId)
    {

        $this->categoryId = $categoryId;

        return $this;
    }

    /**
     * @return string
     */
    public function getCategoryName()
    {

        return $this->categoryName;
    }

    /**
     * @param string $categoryName
     *
     * @return ShopData
     */
    public function setCategoryName($categoryName)
    {

        $this->categoryName = $categoryName;

        return $this;
    }

    /**
     * @return string
     */
    public function getCategoryFolder()
    {
        return $this->categoryFolder;
    }

    /**
     * @param string $categoryFolder
     *
     * @return ShopData
     */
    public function setCategoryFolder($categoryFolder)
    {
        $this->categoryFolder = $categoryFolder;

        return $this;
    }

    /**
     * @return string
     */
    public function getColor()
    {

        return $this->color;
    }

    /**
     * @param string $color
     *
     * @return ShopData
     */
    public function setColor($color)
    {

        $this->color = $color;

        return $this;
    }

    /**
     * @return string
     */
    public function getFamilyLinkId()
    {

        return $this->familyLinkId;
    }

    /**
     * @param string $familyLinkId
     *
     * @return ShopData
     */
    public function setFamilyLinkId($familyLinkId)
    {

        $this->familyLinkId = $familyLinkId;

        return $this;
    }

    /**
     * @return string
     */
    public function getFullUpdate()
    {

        return $this->fullUpdate;
    }

    /**
     * @param string $fullUpdate
     *
     * @return ShopData
     */
    public function setFullUpdate($fullUpdate)
    {

        $this->fullUpdate = $fullUpdate;

        return $this;
    }

    /**
     * @return string
     */
    public function getPartialUpdate()
    {

        return $this->partialUpdate;
    }

    /**
     * @param string $partialUpdate
     *
     * @return ShopData
     */
    public function setPartialUpdate($partialUpdate)
    {

        $this->partialUpdate = $partialUpdate;

        return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {

        return $this->price;
    }

    /**
     * @param float $price
     *
     * @return ShopData
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * @return float
     */
    public function getPriceUvp()
    {
        return $this->priceUvp;
    }

    /**
     * @param float $priceUvp
     * @return ShopData
     */
    public function setPriceUvp($priceUvp)
    {
        $this->priceUvp = $priceUvp;
        return $this;
    }

    /**
     * @return string
     */
    public function getShopAssignment()
    {

        return $this->shopAssignment;
    }

    /**
     * @param string $shopAssignment
     *
     * @return ShopData
     */
    public function setShopAssignment($shopAssignment)
    {

        $this->shopAssignment = $shopAssignment;

        return $this;
    }

    /**
     * @return string
     */
    public function getVendorItemNo()
    {

        return $this->vendorItemNo;
    }

    /**
     * @param string $vendorItemNo
     *
     * @return ShopData
     */
    public function setVendorItemNo($vendorItemNo)
    {

        $this->vendorItemNo = $vendorItemNo;

        return $this;
    }
}
