<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Customer;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Publikat\Model\Xml\Customer\Customer;
use Publikat\Model\Xml\Customer\CustomerShippingAddress;
use Publikat\Model\Xml\Customer\CustomerTransfer;

class CustomerTransferTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/customer.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {
        /**
         * @var $customerTransferObject CustomerTransfer
         */
        $customerTransferObject = $this->serializer->deserialize($this->xml,
            'Publikat\Model\Xml\Customer\CustomerTransfer',
            'xml');

        $this->assertNotNull($customerTransferObject->getNavInsertTime());


    }

    public function testSerialize()
    {


        $customerShippingAddress = new CustomerShippingAddress();
        $customerShippingAddress2 = new CustomerShippingAddress();
        $customerTransferObject = new CustomerTransfer();
        $customer = new Customer();

        $customerShippingAddress->setZip(12312)
            ->setStreetNumber('123')
            ->setStreet('Straße')
            ->setOptAddress('-')
            ->setNameLast('Nachname')
            ->setNameFirst('Vorname')
            ->setNameCompany2('test1')
            ->setNameCompany('test2')
            ->setIsConform(1)
            ->setId(2)
            ->setDateCreated(123123223)
            ->setCountryId(1)
            ->setCity('Stadt')
            ->setType(1);

        $customerShippingAddress2->setZip(12312)
            ->setStreetNumber('123')
            ->setStreet('Straße')
            ->setOptAddress('-')
            ->setNameLast('Nachname')
            ->setNameFirst('Vorname')
            ->setNameCompany2('test1')
            ->setNameCompany('test2')
            ->setIsConform(1)
            ->setId(2)
            ->setDateCreated(12312323434)
            ->setCountryId(1)
            ->setCity('Stadt')
            ->setType(1);

        $customer->setDelete(false)
            ->setBirthday(\DateTime::createFromFormat('Y-m-d','2017-01-01'))
            ->setCity('MusterStadt')
            ->setCountryId(1)
            ->setCustomerNo(2)
            ->setCustomerType('DEFAULT')
            ->setDateCreated(1227804581)
            ->setEmail('test@test.de')
            ->setFax(123123)
            ->setGender(1)
            ->setBusinessPostingId(2)
            ->setId(1)
            ->setIsConform(1)
            ->setLanguageToken('DE')
            ->setNameCompany('test1')
            ->setNameCompany2('test2')
            ->setNameFirst('Max')
            ->setNameLast('Muster')
            ->setOptAddress('-')
            ->setPassword('12312r33r23r')
            ->setPaymentTermsId(1)
            ->setPhone('123123123')
            ->setPhoneMobile('435345345345')
            ->setDiscountGroup('ABC')
            ->setShippingAddresses([$customerShippingAddress, $customerShippingAddress2])
            ->setShopGroup(123)
            ->setShopId('123')
            ->setStreet('Straße')
            ->setStreetNumber('123')
            ->setSystemId(1)
            ->setVat('123')
            ->setZip(12312);

        $customerTransferObject->setNavInsertTime('2017')
            ->setTransferId(123)
            ->setCustomer($customer);


        $xml = $this->serializer->serialize($customerTransferObject, 'xml');
        $this->assertContains('12312r33r23r', $xml);
        $this->assertContains('12312323434', $xml);
        $this->assertContains('123123223', $xml);

        $this->iterateAndAssertGetter($customerTransferObject);
        $this->iterateAndAssertGetter($customerTransferObject->getCustomer());
        $this->iterateAndAssertGetter($customerTransferObject->getCustomer()->getShippingAddresses()[0]);

    }

    /**
     * @param $objectToTest
     */
    private function iterateAndAssertGetter($objectToTest)
    {
        foreach (get_class_methods(get_class($objectToTest)) as $method) {
            if (strpos($method, 'set') === false) {
                $getterValue = $objectToTest->{$method}();
                $this->assertNotNull($getterValue);
            }
        }
    }

}
