<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Discount\CustomerDiscountGroup;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Publikat\Model\Xml\Discount\CustomerDiscountGroup\CustomerDiscountGroup;
use Publikat\Model\Xml\Discount\CustomerDiscountGroup\CustomerDiscountGroupTransfer;
use Publikat\Model\Xml\ItemList;


class CustomerDiscountGroupTransferTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../../data/customerDiscountGroup.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {
        /**
         * @var $customerDiscountGroupTransferObject CustomerDiscountGroupTransfer
         */
        $customerDiscountGroupTransferObject = $this->serializer->deserialize($this->xml,
            'Publikat\Model\Xml\Discount\CustomerDiscountGroup\CustomerDiscountGroupTransfer',
            'xml');

        $this->assertCount(2,
            $customerDiscountGroupTransferObject->getCustomerDiscountGroup()->getCustomerDiscountGroups()->getItems());

    }

    public function testSerialize()
    {
        $itemList = new ItemList();
        $itemList->setItems(['test', 'test2']);

        $customerDiscountGroup = new CustomerDiscountGroup();
        $customerDiscountGroup->setCustomerId(123);
        $customerDiscountGroup->setCustomerDiscountGroups($itemList);
        $customerDiscountGroup->setDelete(false);

        $customerDiscountGroupTransfer = new CustomerDiscountGroupTransfer();
        $customerDiscountGroupTransfer->setCustomerDiscountGroup($customerDiscountGroup);
        $customerDiscountGroupTransfer->setNavInsertTime("2017");
        $customerDiscountGroupTransfer->setTransferId(123);

        $xml = $this->serializer->serialize($customerDiscountGroupTransfer, 'xml');
        $this->assertContains('test2', $xml);

        $this->iterateAndAssertGetter($customerDiscountGroupTransfer);
        $this->iterateAndAssertGetter($customerDiscountGroupTransfer->getCustomerDiscountGroup());
    }

    /**
     * @param $objectToTest
     */
    private function iterateAndAssertGetter($objectToTest)
    {
        foreach (get_class_methods(get_class($objectToTest)) as $method) {
            if (strpos($method, 'set') === false) {
                $getterValue = $objectToTest->{$method}();
                $this->assertNotNull($getterValue);
            }
        }
    }

}
