<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Discount\Discount;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Publikat\Model\Xml\Discount\Discount\Discount;
use Publikat\Model\Xml\Discount\Discount\DiscountProperties;
use Publikat\Model\Xml\Discount\Discount\DiscountPropertiesList;
use Publikat\Model\Xml\Discount\Discount\DiscountTransfer;
use Publikat\Model\Xml\ItemList;


class DiscountTransferTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../../data/discount.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {
        /**
         * @var $discountTransferObject DiscountTransfer
         */
        $discountTransferObject = $this->serializer->deserialize($this->xml,
            'Publikat\Model\Xml\Discount\Discount\DiscountTransfer',
            'xml');

        $this->assertCount(2,
            $discountTransferObject->getDiscount()->getDiscountProperties()->getItems());

    }

    public function testSerialize()
    {
        $itemList = new DiscountPropertiesList();

        $property = new DiscountProperties();
        $property->setDiscountPercentage(65656565);
        $property->setQuantity(87878787);

        $itemList->setItems([$property]);


        $discount = new Discount();
        $discount->setDelete(false);
        $discount->setProductDiscountGroup('123123');
        $discount->setCustomerDiscountGroup('345345');
        $discount->setDiscountProperties($itemList);

        $discountTransfer = new DiscountTransfer();
        $discountTransfer->setTransferId(33333);
        $discountTransfer->setNavInsertTime(2017);
        $discountTransfer->setDiscount($discount);


        $xml = $this->serializer->serialize($discountTransfer, 'xml');
        $this->assertContains('65656565', $xml);
        $this->assertContains('87878787', $xml);
        $this->assertContains('33333', $xml);
        $this->assertContains('2017', $xml);
        $this->assertContains('false', $xml);

        $this->iterateAndAssertGetter($discountTransfer);
        $this->iterateAndAssertGetter($discountTransfer->getDiscount());
        $this->iterateAndAssertGetter($discountTransfer->getDiscount()->getDiscountProperties()->getItems()[0]);
    }

    /**
     * @param $objectToTest
     */
    private function iterateAndAssertGetter($objectToTest)
    {
        foreach (get_class_methods(get_class($objectToTest)) as $method) {
            if (strpos($method, 'set') === false) {
                $getterValue = $objectToTest->{$method}();
                $this->assertNotNull($getterValue);
            }
        }
    }

}
