<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Item;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Publikat\Model\Xml\Item\Item;
use Publikat\Model\Xml\Item\Sales30DaysAmazon;

class ItemTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/availability.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {

        /**
         * @var \Publikat\Model\Xml\Item\ItemTransfer $itemTransferObject
         */
        $itemTransferObject = $this->serializer->deserialize($this->xml, 'Publikat\Model\Xml\Item\ItemTransfer', 'xml');

        $itemObject = $itemTransferObject->getAvailability()->getItem();

        $this->assertEquals('SO49777401060', $itemObject->getItemCode());
        $this->assertEquals(1, $itemObject->getQtyStock());
        $this->assertEquals(10, $itemObject->getQtySalesOrder());
        $this->assertEquals(8, $itemObject->getQtySalesOrderQuar());
        $this->assertEquals(825, $itemObject->getQtyPreOrder());
        $this->assertEquals(2247, $itemObject->getQtyPurchaseOrder());
        $this->assertEquals(-17, $itemObject->getRealQty());
        $this->assertEquals(2230, $itemObject->getQuantityOnStock());
        $this->assertEquals(1, $itemObject->getIsOrderable());
        $this->assertEquals(21, $itemObject->getShippingState());
        $this->assertEquals('2016-03-08', $itemObject->getShippingDate());
        $this->assertEquals('2016-02-25', $itemObject->getShippingDateCalculated());
        $this->assertEquals(-1, $itemObject->getSales90Days());
        $this->assertEquals(0, $itemObject->getSales30Days());
        $this->assertEquals(-1, $itemObject->getSales90DaysAll());
        $this->assertEquals(0, $itemObject->getSales30DaysAll());
        $this->assertEquals(2, $itemObject->getSales60DaysGross());
        $this->assertEquals(3717, $itemObject->getSalesTotalGross());
        $this->assertEquals('STYLEF', $itemObject->getShopGroup());

        $this->assertInstanceOf('Publikat\Model\Xml\Item\Sales30DaysAmazon', $itemObject->getSales30DaysAmazon());

        $this->assertEquals(0, $itemObject->getSales30DaysWeare());
        $this->assertEquals(2, $itemObject->getQtyReturns60Days());
        $this->assertEquals(273, $itemObject->getQtyReturnsTotal());
        $this->assertEquals(0, $itemObject->getReturnsRate60Days());
        $this->assertEquals(0.07, $itemObject->getReturnsRateTotal());
        $this->assertEquals(4, $itemObject->getMinInventory());
        $this->assertEquals(8, $itemObject->getMaxInventory());
        $this->assertEquals(0.2, $itemObject->getDynRange1());
        $this->assertEquals(0.4, $itemObject->getDynRange2());
        $this->assertEquals(0.8, $itemObject->getDynPeriod());
        $this->assertEquals('SU', $itemObject->getDyn());
        $this->assertEquals('Auffüllen auf Maximalbestand', $itemObject->getRestockPolicy());
        $this->assertEquals('', $itemObject->getPurchaseOrderDate());
        $this->assertEquals('2015-09-14', $itemObject->getLastSale());
        $this->assertEquals('2015-09-04', $itemObject->getLastPurchase());
        $this->assertEquals('2015-09-24', $itemObject->getAvailabilityDate());
    }

    public function testSetter()
    {

        $itemObject = new Item();
        $sales30DaysAmazon = new Sales30DaysAmazon();

        $itemObject->setAvailabilityDate('dummy');
        $itemObject->setDyn('dummy');
        $itemObject->setDynPeriod('dummy');
        $itemObject->setDynRange1('dummy');
        $itemObject->setDynRange2('dummy');
        $itemObject->setIsOrderable('dummy');
        $itemObject->setItemCode('dummy');
        $itemObject->setLastPurchase('dummy');
        $itemObject->setLastSale('dummy');
        $itemObject->setMaxInventory('dummy');
        $itemObject->setMinInventory('dummy');
        $itemObject->setPurchaseOrderDate('dummy');
        $itemObject->setQtyPreOrder('dummy');
        $itemObject->setQtyPurchaseOrder('dummy');
        $itemObject->setQtyReturns60Days('dummy');
        $itemObject->setQtyReturnsTotal('dummy');
        $itemObject->setQtySalesOrder('dummy');
        $itemObject->setQtySalesOrderQuar('dummy');
        $itemObject->setQtyStock('dummy');
        $itemObject->setQuantityOnStock('dummy');
        $itemObject->setRealQty('dummy');
        $itemObject->setRestockPolicy('dummy');
        $itemObject->setReturnsRate60Days('dummy');
        $itemObject->setReturnsRateTotal('dummy');
        $itemObject->setSales30Days('dummy');
        $itemObject->setSales30DaysAll('dummy');
        $itemObject->setSales30DaysAmazon($sales30DaysAmazon);
        $itemObject->setSales30DaysWeare('dummy');
        $itemObject->setSales60DaysGross('dummy');
        $itemObject->setSales90Days('dummy');
        $itemObject->setSales90DaysAll('dummy');
        $itemObject->setSalesTotalGross('dummy');
        $itemObject->setShippingDate('dummy');
        $itemObject->setShippingDateCalculated('dummy');
        $itemObject->setShippingState('dummy');

        $this->assertEquals('dummy', $itemObject->getAvailabilityDate());
        $this->assertEquals('dummy', $itemObject->getDyn());
        $this->assertEquals('dummy', $itemObject->getDynPeriod());
        $this->assertEquals('dummy', $itemObject->getDynRange1());
        $this->assertEquals('dummy', $itemObject->getDynRange2());
        $this->assertEquals('dummy', $itemObject->getIsOrderable());
        $this->assertEquals('dummy', $itemObject->getItemCode());
        $this->assertEquals('dummy', $itemObject->getLastPurchase());
        $this->assertEquals('dummy', $itemObject->getLastSale());
        $this->assertEquals('dummy', $itemObject->getMaxInventory());
        $this->assertEquals('dummy', $itemObject->getMinInventory());
        $this->assertEquals('dummy', $itemObject->getPurchaseOrderDate());
        $this->assertEquals('dummy', $itemObject->getQtyPreOrder());
        $this->assertEquals('dummy', $itemObject->getQtyPurchaseOrder());
        $this->assertEquals('dummy', $itemObject->getQtyReturns60Days());
        $this->assertEquals('dummy', $itemObject->getQtyReturnsTotal());
        $this->assertEquals('dummy', $itemObject->getQtySalesOrder());
        $this->assertEquals('dummy', $itemObject->getQtySalesOrderQuar());
        $this->assertEquals('dummy', $itemObject->getQtyStock());
        $this->assertEquals('dummy', $itemObject->getQuantityOnStock());
        $this->assertEquals('dummy', $itemObject->getRealQty());
        $this->assertEquals('dummy', $itemObject->getRestockPolicy());
        $this->assertEquals('dummy', $itemObject->getReturnsRate60Days());
        $this->assertEquals('dummy', $itemObject->getReturnsRateTotal());
        $this->assertEquals('dummy', $itemObject->getSales30Days());
        $this->assertEquals('dummy', $itemObject->getSales30DaysAll());
        $this->assertInstanceOf('Publikat\Model\Xml\Item\Sales30DaysAmazon', $itemObject->getSales30DaysAmazon());
        $this->assertEquals('dummy', $itemObject->getSales30DaysWeare());
        $this->assertEquals('dummy', $itemObject->getSales60DaysGross());
        $this->assertEquals('dummy', $itemObject->getSales90Days());
        $this->assertEquals('dummy', $itemObject->getSales90DaysAll());
        $this->assertEquals('dummy', $itemObject->getSalesTotalGross());
        $this->assertEquals('dummy', $itemObject->getShippingDate());
        $this->assertEquals('dummy', $itemObject->getShippingDateCalculated());
        $this->assertEquals('dummy', $itemObject->getShippingState());
    }
}
