<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */
namespace Tests\Publikat\Model\Xml\Item;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Publikat\Model\Xml\Item\Availability;
use Publikat\Model\Xml\Item\ItemTransfer;
use Publikat\Model\Xml\Item\ShopData;

class ItemTransferTest extends TestCase
{
    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {
        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/availability.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {
        /**
         * @var ItemTransfer $itemTransferObject
         */
        $itemTransferObject = $this->serializer->deserialize($this->xml, 'Publikat\Model\Xml\Item\ItemTransfer', 'xml');

        $this->assertNotEmpty($itemTransferObject->getId());
        $this->assertEquals(247143, $itemTransferObject->getTransferId());
        $this->assertEquals('2016-04-06 15:40:39', $itemTransferObject->getNavInsertTime());

        $this->assertInstanceOf('Publikat\Model\Xml\Item\Availability', $itemTransferObject->getAvailability());
        $this->assertInstanceOf('Publikat\Model\Xml\Item\ShopData', $itemTransferObject->getShopData());

        $this->assertNotEmpty($itemTransferObject->getLogData());
    }

    public function testDeserializeNoItemInXml()
    {
        $xml = file_get_contents(realpath(__DIR__ . '/../../../../data/availabilityNoItem.xml'));
        /**
         * @var ItemTransfer $itemTransferObject
         */
        $itemTransferObject = $this->serializer->deserialize($xml, 'Publikat\Model\Xml\Item\ItemTransfer', 'xml');

        $this->assertNotEmpty($itemTransferObject->getId());
        $this->assertEquals(5176, $itemTransferObject->getTransferId());
        $this->assertEquals('2017-05-03 07:21:31', $itemTransferObject->getNavInsertTime());
        $this->assertEquals('ListingHex', $itemTransferObject->getItemType());

        $this->assertInstanceOf('Publikat\Model\Xml\Item\Availability', $itemTransferObject->getAvailability());

        $this->assertNotEmpty($itemTransferObject->getLogData());
    }

    public function testSetter()
    {
        $itemTransferObject = new ItemTransfer();

        $availabilityObject = new Availability();
        $shopDataObject = new ShopData();

        $itemTransferObject->setAvailability($availabilityObject);
        $itemTransferObject->setNavInsertTime('2016-04-06 15:40:39');
        $itemTransferObject->setShopData($shopDataObject);
        $itemTransferObject->setTransferId('xyz');
        $itemTransferObject->setItemType('Single');

        $this->assertInstanceOf('Publikat\Model\Xml\Item\Availability', $itemTransferObject->getAvailability());
        $this->assertEquals('2016-04-06 15:40:39', $itemTransferObject->getNavInsertTime());
        $this->assertEquals('Single', $itemTransferObject->getItemType());
        $this->assertInstanceOf('Publikat\Model\Xml\Item\ShopData', $itemTransferObject->getShopData());
        $this->assertEquals('xyz', $itemTransferObject->getTransferId());
    }
}
