<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Price;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Publikat\Model\Xml\Price\Price;
use Publikat\Model\Xml\Price\PriceTransfer;

class PriceTransferTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/price.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {

        /**
         * @var $priceTransferObject PriceTransfer
         */
        $priceTransferObject = $this->serializer->deserialize(
            $this->xml,
            'Publikat\Model\Xml\Price\PriceTransfer',
            'xml'
        );

        $this->iterateAndAssertGetter($priceTransferObject);
        $this->iterateAndAssertGetter($priceTransferObject->getPrice());

        $this->assertEquals('2016-04-06 15:40:38', $priceTransferObject->getNavInsertTime());
        $this->assertInstanceOf('Publikat\Model\Xml\Price\Price', $priceTransferObject->getPrice());
        $this->assertEquals(20.9, $priceTransferObject->getPrice()->getCurrentPrice());

        $this->assertEquals('true', $priceTransferObject->getPrice()->getDynamicSalesPrice());

    }

    /**
     * bullshit!
     */
    public function testSerialize()
    {
        $testString = "test123";
        $price = new Price();
        $price->setCurrentPrice($testString)
            ->setArticleNumber($testString)
            ->setCurrency($testString)
            ->setSpecialPrice($testString)
            ->setOriginalPrice($testString)
            ->setProductGroup($testString)
            ->setPriceType(0)
            ->setDelete(true)
            ->setSystemId($testString)
            ->setPriceSender('PHPUnit')
            ->setPriceRule('')
            ->setPriceTime(time());

        $priceTransferObject = new PriceTransfer();
        $priceTransferObject
            ->setPrice($price)
            ->setNavInsertTime($testString)
            ->setTransferId($testString)
            ->setItemType('ListingHex');

        $serializedXml = $this->serializer->serialize($priceTransferObject, 'xml');
        $this->assertEquals(4, substr_count($serializedXml, $testString));
    }

    /**
     * @param $objectToTest
     */
    private function iterateAndAssertGetter($objectToTest)
    {
        foreach (get_class_methods(get_class($objectToTest)) as $method) {
            if (strpos($method, 'set') === false) {
                $getterValue = $objectToTest->{$method}();
                $this->assertNotNull($getterValue);
            }
        }
    }
}
