<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\Discount;

use JMS\Serializer\Annotation as Serializer;

/**
 * Discount
 *
 * @Serializer\XmlRoot("Discount")
 * @Serializer\ExclusionPolicy("all")
 */
class Discount
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CustomerDiscountGroup")
     * @Serializer\Type("string")
     *
     */
    private $customerDiscountGroup;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ProductDiscountGroup")
     * @Serializer\Type("string")
     *
     */
    private $productDiscountGroup;


    /**
     * @var DiscountPropertiesList
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("List")
     * @Serializer\Type("Publikat\Model\Xml\Discount\Discount\DiscountPropertiesList")
     *
     */
    private $discountProperties;

    /**
     * @var boolean
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("boolean")
     *
     */
    private $delete;

    /**
     * @return string
     */
    public function getCustomerDiscountGroup()
    {
        return $this->customerDiscountGroup;
    }

    /**
     * @param string $customerDiscountGroup
     * @return Discount
     */
    public function setCustomerDiscountGroup($customerDiscountGroup)
    {
        $this->customerDiscountGroup = $customerDiscountGroup;
        return $this;
    }

    /**
     * @return string
     */
    public function getProductDiscountGroup()
    {
        return $this->productDiscountGroup;
    }

    /**
     * @param string $productDiscountGroup
     * @return Discount
     */
    public function setProductDiscountGroup($productDiscountGroup)
    {
        $this->productDiscountGroup = $productDiscountGroup;
        return $this;
    }

    /**
     * @return DiscountPropertiesList
     */
    public function getDiscountProperties()
    {
        return $this->discountProperties;
    }

    /**
     * @param DiscountPropertiesList $discountProperties
     * @return Discount
     */
    public function setDiscountProperties($discountProperties)
    {
        $this->discountProperties = $discountProperties;
        return $this;
    }


    /**
     * @return bool
     */
    public function isDelete()
    {
        return $this->delete;
    }

    /**
     * @param bool $delete
     * @return Discount
     */
    public function setDelete($delete)
    {
        $this->delete = $delete;
        return $this;
    }
}
