<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\Discount;

use JMS\Serializer\Annotation as Serializer;

/**
 * DiscountProperties
 *
 * @Serializer\XmlRoot("Item")
 * @Serializer\ExclusionPolicy("all")
 */
class DiscountProperties
{

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Quantity")
     * @Serializer\Type("integer")
     */
    private $quantity;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DiscountPercentage")
     * @Serializer\Type("integer")
     */
    private $discountPercentage;

    /**
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     * @return DiscountProperties
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
        return $this;
    }

    /**
     * @return int
     */
    public function getDiscountPercentage()
    {
        return $this->discountPercentage;
    }

    /**
     * @param int $discountPercentage
     * @return DiscountProperties
     */
    public function setDiscountPercentage($discountPercentage)
    {
        $this->discountPercentage = $discountPercentage;
        return $this;
    }
}
