<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\ProductDiscountGroup;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ModelInterface;

/**
 * ProductDiscountGroupTransfer
 *
 * @Serializer\XmlRoot("ProductDiscountGroupTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class ProductDiscountGroupTransfer implements ModelInterface
{

    /**
     * @var ProductDiscountGroup
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ProductDiscountGroup")
     * @Serializer\Type("Publikat\Model\Xml\Discount\ProductDiscountGroup\ProductDiscountGroup")
     *
     */
    private $productDiscountGroup;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NavInsertTime")
     * @Serializer\Type("string")
     */
    private $navInsertTime;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     */
    private $transferId;

    /**
     * @return int
     */
    public function getId()
    {

        return $this->getProductDiscountGroup()->getProductGroupCode();
    }

    /**
     * @return string
     */
    public function getLogData()
    {

        return print_r($this, true);
    }

    /**
     * @return ProductDiscountGroup
     */
    public function getProductDiscountGroup()
    {
        return $this->productDiscountGroup;
    }

    /**
     * @param ProductDiscountGroup $productDiscountGroup
     * @return ProductDiscountGroupTransfer
     */
    public function setProductDiscountGroup($productDiscountGroup)
    {
        $this->productDiscountGroup = $productDiscountGroup;
        return $this;
    }

    /**
     * @return string
     */
    public function getNavInsertTime()
    {
        return $this->navInsertTime;
    }

    /**
     * @param string $navInsertTime
     * @return ProductDiscountGroupTransfer
     */
    public function setNavInsertTime($navInsertTime)
    {
        $this->navInsertTime = $navInsertTime;
        return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {
        return $this->transferId;
    }

    /**
     * @param int $transferId
     * @return ProductDiscountGroupTransfer
     */
    public function setTransferId($transferId)
    {
        $this->transferId = $transferId;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getLogFileName()
    {
        return $this->getId();
    }
}
