<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml;

use JMS\Serializer\Annotation as Serializer;

/**
 * ItemList
 *
 * @Serializer\XmlRoot("List")
 * @Serializer\ExclusionPolicy("all")
 */
class ItemList
{

    /**
     * @var string[]
     *
     * @Serializer\Expose
     * @Serializer\XmlList(inline = true, entry= "Item")
     * @Serializer\Type("array<string>")
     *
     */
    private $items;

    /**
     * @return \string[]
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * @param \string[] $items
     * @return ItemList
     */
    public function setItems($items)
    {
        $this->items = $items;
        return $this;
    }
}
