<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Discount\ProductDiscountGroup;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Publikat\Model\Xml\Discount\ProductDiscountGroup\ProductDiscountGroup;
use Publikat\Model\Xml\Discount\ProductDiscountGroup\ProductDiscountGroupTransfer;
use Publikat\Model\Xml\ItemList;

class ProductDiscountGroupTransferTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../../data/productDiscountGroup.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {
        /**
         * @var $productDiscountGroupTransferObject ProductDiscountGroupTransfer
         */
        $productDiscountGroupTransferObject = $this->serializer->deserialize(
            $this->xml,
            'Publikat\Model\Xml\Discount\ProductDiscountGroup\ProductDiscountGroupTransfer',
            'xml'
        );

        $this->assertCount(
            2,
            $productDiscountGroupTransferObject->getProductDiscountGroup()->getProductDiscountGroups()->getItems()
        );
    }

    public function testSerialize()
    {
        $itemList = new ItemList();
        $itemList->setItems(['test', 'test2']);

        $discountGroup = new ProductDiscountGroup();
        $discountGroup->setProductGroupCode(123);
        $discountGroup->setProductDiscountGroups($itemList);
        $discountGroup->setDelete(false);

        $productDiscountGroupTransfer = new ProductDiscountGroupTransfer();
        $productDiscountGroupTransfer->setProductDiscountGroup($discountGroup);
        $productDiscountGroupTransfer->setNavInsertTime("2017");
        $productDiscountGroupTransfer->setTransferId(123);

        $xml = $this->serializer->serialize($productDiscountGroupTransfer, 'xml');
        $this->assertContains('test2', $xml);

        $this->iterateAndAssertGetter($productDiscountGroupTransfer);
        $this->iterateAndAssertGetter($productDiscountGroupTransfer->getProductDiscountGroup());
    }

    /**
     * @param $objectToTest
     */
    private function iterateAndAssertGetter($objectToTest)
    {
        foreach (get_class_methods(get_class($objectToTest)) as $method) {
            if (strpos($method, 'set') === false) {
                $getterValue = $objectToTest->{$method}();
                $this->assertNotNull($getterValue);
            }
        }
    }
}
