<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Publikat\Model\Xml\Item;

use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;

class Sales30DaysAmazonTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;
    private $xml;

    public function setUp(): void
    {

        $this->xml = file_get_contents(realpath(__DIR__ . '/../../../../data/availability.xml'));
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testDeserialize()
    {

        /**
         * @var \Publikat\Model\Xml\Item\ItemTransfer $itemTransferObject
         */
        $itemTransferObject = $this->serializer->deserialize($this->xml, 'Publikat\Model\Xml\Item\ItemTransfer', 'xml');

        /**
         * @var \Publikat\Model\Xml\Item\Availability $availabilityObject
         */
        $sales30DaysAmazonObject = $itemTransferObject->getAvailability()->getSales30DaysAmazon();

        $this->assertEquals(1, $sales30DaysAmazonObject->getSummary());
        $this->assertEquals(2, $sales30DaysAmazonObject->getDe());
        $this->assertEquals(3, $sales30DaysAmazonObject->getFr());
        $this->assertEquals(4, $sales30DaysAmazonObject->getIt());
        $this->assertEquals(5, $sales30DaysAmazonObject->getEs());
    }
}
