<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Customer;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ModelInterface;

/**
 * CustomerTransfer
 *
 * @Serializer\XmlRoot("CustomerTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class CustomerTransfer implements ModelInterface
{

    /**
     * @var \Publikat\Model\Xml\Customer\Customer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Customer")
     * @Serializer\Type("Publikat\Model\Xml\Customer\Customer")
     *
     */
    private $customer;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NavInsertTime")
     * @Serializer\Type("string")
     */
    private $navInsertTime;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     */
    private $transferId;

    /**
     * @return int
     */
    public function getId()
    {

        return $this->getCustomer()->getId();
    }

    /**
     * @return string
     */
    public function getLogData()
    {

        return print_r($this, true);
    }

    /**
     * @return string
     */
    public function getNavInsertTime()
    {
        return $this->navInsertTime;
    }

    /**
     * @param string $navInsertTime
     * @return CustomerTransfer
     */
    public function setNavInsertTime($navInsertTime)
    {
        $this->navInsertTime = $navInsertTime;
        return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {
        return $this->transferId;
    }

    /**
     * @param int $transferId
     * @return CustomerTransfer
     */
    public function setTransferId($transferId)
    {
        $this->transferId = $transferId;
        return $this;
    }

    /**
     * @return \Publikat\Model\Xml\Customer\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * @param \Publikat\Model\Xml\Customer\Customer $customer
     * @return CustomerTransfer
     */
    public function setCustomer($customer)
    {
        $this->customer = $customer;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getLogFileName()
    {
        return $this->getId();
    }
}
