<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\CustomerDiscountGroup;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ItemList;

/**
 * CustomerDiscountGroup
 *
 * @Serializer\XmlRoot("CustomerDiscountGroup")
 * @Serializer\ExclusionPolicy("all")
 */
class CustomerDiscountGroup
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("CustomerId")
     * @Serializer\Type("integer")
     *
     */
    private $customerId;

    /**
     * @var ItemList
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("List")
     * @Serializer\Type("Publikat\Model\Xml\ItemList")
     *
     */
    private $customerDiscountGroups;

    /**
     * @var boolean
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("boolean")
     *
     */
    private $delete;


    /**
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }

    /**
     * @param string $customerId
     * @return CustomerDiscountGroup
     */
    public function setCustomerId($customerId)
    {
        $this->customerId = $customerId;
        return $this;
    }

    /**
     * @return ItemList
     */
    public function getCustomerDiscountGroups()
    {
        return $this->customerDiscountGroups;
    }

    /**
     * @param ItemList $customerDiscountGroups
     * @return CustomerDiscountGroup
     */
    public function setCustomerDiscountGroups($customerDiscountGroups)
    {
        $this->customerDiscountGroups = $customerDiscountGroups;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDelete()
    {
        return $this->delete;
    }

    /**
     * @param bool $delete
     * @return CustomerDiscountGroup
     */
    public function setDelete($delete)
    {
        $this->delete = $delete;
        return $this;
    }
}
