<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\Discount;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ModelInterface;

/**
 * DiscountTransfer
 *
 * @Serializer\XmlRoot("DiscountTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class DiscountTransfer implements ModelInterface
{

    /**
     * @var Discount
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Discount")
     * @Serializer\Type("Publikat\Model\Xml\Discount\Discount\Discount")
     *
     */
    private $discount;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NavInsertTime")
     * @Serializer\Type("string")
     */
    private $navInsertTime;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     */
    private $transferId;

    /**
     * @return int
     */
    public function getId()
    {

        return $this->getDiscount()->getProductDiscountGroup() . '_' . $this->getDiscount()->getCustomerDiscountGroup();
    }

    /**
     * @return string
     */
    public function getLogData()
    {

        return print_r($this, true);
    }

    /**
     * @return string
     */
    public function getNavInsertTime()
    {
        return $this->navInsertTime;
    }

    /**
     * @param string $navInsertTime
     * @return DiscountTransfer
     */
    public function setNavInsertTime($navInsertTime)
    {
        $this->navInsertTime = $navInsertTime;
        return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {
        return $this->transferId;
    }

    /**
     * @param int $transferId
     * @return DiscountTransfer
     */
    public function setTransferId($transferId)
    {
        $this->transferId = $transferId;
        return $this;
    }

    /**
     * @return Discount
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * @param Discount $discount
     * @return DiscountTransfer
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getLogFileName()
    {
        return $this->getId();
    }
}
