<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Family\Relation;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ItemList;

/**
 * FamilyRelation
 *
 * @Serializer\XmlRoot("FamilyRelation")
 * @Serializer\ExclusionPolicy("all")
 */
class FamilyRelation
{

    /**
     * @var int
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("FamilyId")
     * @Serializer\Type("int")
     *
     */
    private $familyId;
    /**
     * @var ItemList
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("List")
     * @Serializer\Type("Publikat\Model\Xml\ItemList")
     *
     */
    private $relatedFamilyIds;

    /**
     * @var boolean
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("boolean")
     *
     */
    private $delete;

    /**
     * @return int
     */
    public function getFamilyId()
    {
        return $this->familyId;
    }

    /**
     * @param int $familyId
     *
     * @return FamilyRelation
     */
    public function setFamilyId($familyId)
    {
        $this->familyId = $familyId;

        return $this;
    }

    /**
     * @return ItemList
     */
    public function getRelatedFamilyIds()
    {
        return $this->relatedFamilyIds;
    }

    /**
     * @param ItemList $relatedFamilyIds
     *
     * @return FamilyRelation
     */
    public function setRelatedFamilyIds($relatedFamilyIds)
    {
        $this->relatedFamilyIds = $relatedFamilyIds;

        return $this;
    }

    /**
     * @return bool
     */
    public function isDelete()
    {
        return $this->delete;
    }

    /**
     * @param bool $delete
     *
     * @return FamilyRelation
     */
    public function setDelete($delete)
    {
        $this->delete = $delete;

        return $this;
    }
}
