<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Model\Request\Index\Swoox\Item;
use Swoox\Api\Model\Request\Index\Swoox\NameFieldList;

class ItemTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    public function setUp(): void
    {
        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testSerialize()
    {

        $jsonString = '{"DocumentLanguage":"de_DE","DocumentPrefix":"prefix","DocumentRanking":"11","DocumentText":"text","DocumentTitle":"title","DocumentURL":"http:\/\/localhost","DocumentUniqueKey":"xyz","DocumentFields":[{"Name":"test","Values":[]}]}';

        $item = new Item();

        $item->setDocumentUniqueKey('xyz');
        $item->setDocumentLanguage('de_DE');
        $item->setDocumentURL('http://localhost');
        $item->setDocumentTitle('title');
        $item->setDocumentPrefix('prefix');
        $item->setDocumentText('text');
        $item->setDocumentRanking(11);

        $nameFieldList = new NameFieldList();
        $nameFieldList->setName('test');
        $item->setDocumentFields([$nameFieldList]);

        $this->assertEquals($jsonString, $this->serializer->serialize($item, 'json'));


        $jsonString = '{"DocumentLanguage":"de_DE","DocumentPrefix":"prefix","DocumentRanking":"11","DocumentText":"text","DocumentTitle":"title","DocumentURL":"http:\/\/localhost","DocumentUniqueKey":"xyz","DocumentFields":[{"Name":"test","Values":[]},{"Name":"test2","Values":[]}]}';

        $nameFieldList = new NameFieldList();
        $nameFieldList->setName('test2');
        $item->addDocumentFields($nameFieldList);

        $this->assertEquals($jsonString, $this->serializer->serialize($item, 'json'));
    }

    public function testDeserialize()
    {

        $xml = file_get_contents('Tests/data/Swoox/Api/Model/Request/Index/Swoox/item.xml', true);

        /**
         * @var \Swoox\Api\Model\Request\Index\Swoox\Item $item
         */
        $item = $this->serializer->deserialize($xml, 'Swoox\Api\Model\Request\Index\Swoox\Item', 'xml');

        $this->assertInstanceOf('Swoox\Api\Model\Request\Index\Swoox\Item', $item);
        $this->assertEquals('xyz', $item->getDocumentUniqueKey());
        $this->assertEquals('de_DE', $item->getDocumentLanguage());
        $this->assertEquals('prefix', $item->getDocumentPrefix());
        $this->assertEquals('11', $item->getDocumentRanking());
        $this->assertEquals('text', $item->getDocumentText());
        $this->assertEquals('http://localhost', $item->getDocumentURL());
        $this->assertEquals('title', $item->getDocumentTitle());
        $this->assertCount(2, $item->getDocumentFields());
    }
}
