<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Search\Filter;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Search\Filter\Factory;

/**
 * Class FactoryTest
 *
 * @package Tests\Swoox\Api\Model\Request\Search\Filter
 */
class FactoryTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var Factory
     */
    private $factory;

    /**
     * setUp
     */
    public function setUp(): void
    {

        $this->factory = new Factory(new ApiManager());
    }

    /**
     * testTypes
     */
    public function testTypes()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Factory', $this->factory->types());
    }

    /**
     * testRequestModel
     */
    public function testRequestModel()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Request', $this->factory->requestModel());
    }
}
