<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Search\Filter;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Search\Filter\Request;
use Swoox\Api\Model\Request\Search\Filter\Types;

/**
 * Class RequestTest
 *
 * @package Tests\Swoox\Api\Model\Request\Search\Filter
 */
class RequestTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var ApiManager
     */
    private $apiManager;
    /**
     * @var Request
     */
    private $request;

    /**
     * setUp
     */
    public function setUp(): void
    {

        $this->apiManager = new ApiManager();
        $this->request = new Request();
    }

    /**
     * testDateTime
     */
    public function testDateTime()
    {

        $this->request->addDateTime(new Types\DateTime($this->apiManager));
        $this->request->addDateTime(new Types\DateTime($this->apiManager));

        $dateTimes = $this->request->getDateTimes();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $dateTimes);
        $this->assertCount(2, $dateTimes);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\DateTime', $dateTimes[0]);
    }

    /**
     * testFallback
     */
    public function testFallback()
    {

        $this->request->addFallback(new Types\Fallback($this->apiManager));
        $this->request->addFallback(new Types\Fallback($this->apiManager));

        $fallbacks = $this->request->getFallbacks();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $fallbacks);
        $this->assertCount(2, $fallbacks);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Fallback', $fallbacks[0]);
    }

    /**
     * testGeoPoint
     */
    public function testGeoPoint()
    {

        $this->request->addGeoPoint(new Types\GeoPoint($this->apiManager));
        $this->request->addGeoPoint(new Types\GeoPoint($this->apiManager));

        $geoPoints = $this->request->getGeoPoints();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $geoPoints);
        $this->assertCount(2, $geoPoints);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\GeoPoint', $geoPoints[0]);
    }

    /**
     * testGeoShape
     */
    public function testGeoShape()
    {

        $this->request->addGeoShape(new Types\GeoShape($this->apiManager));
        $this->request->addGeoShape(new Types\GeoShape($this->apiManager));

        $geoShapes = $this->request->getGeoShapes();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $geoShapes);
        $this->assertCount(2, $geoShapes);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\GeoShape', $geoShapes[0]);
    }

    /**
     * testMultiSelect
     */
    public function testMultiSelect()
    {

        $this->request->addMultiSelect(new Types\MultiSelect($this->apiManager));
        $this->request->addMultiSelect(new Types\MultiSelect($this->apiManager));

        $multiSelects = $this->request->getMultiSelects();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $multiSelects);
        $this->assertCount(2, $multiSelects);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\MultiSelect', $multiSelects[0]);
    }

    /**
     * testMultiValue
     */
    public function testMultiValue()
    {

        $this->request->addMultiValue(new Types\MultiValue($this->apiManager));
        $this->request->addMultiValue(new Types\MultiValue($this->apiManager));

        $multiValues = $this->request->getMultiValues();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $multiValues);
        $this->assertCount(2, $multiValues);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\MultiValue', $multiValues[0]);
    }

    /**
     * testRange
     */
    public function testRange()
    {

        $this->request->addRange(new Types\Range($this->apiManager));
        $this->request->addRange(new Types\Range($this->apiManager));

        $ranges = $this->request->getRanges();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $ranges);
        $this->assertCount(2, $ranges);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Range', $ranges[0]);
    }

    /**
     * testValue
     */
    public function testValue()
    {

        $this->request->addValue(new Types\Value($this->apiManager));
        $this->request->addValue(new Types\Value($this->apiManager));

        $values = $this->request->getValues();
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $values);
        $this->assertCount(2, $values);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Value', $values[0]);
    }

    /**
     * testError
     */
    public function testError()
    {

        $this->request->addError(new Types\Error($this->apiManager));
        $this->request->addError(new Types\Error($this->apiManager));

        $error = $this->request->error;
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $error);
        $this->assertCount(2, $error);

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Error', $error[0]);
    }

    /**
     * testDefaults
     */
    public function testDefaults()
    {

        $this->request->setDefaults(new Types\Defaults());

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Types\Defaults', $this->request->getDefaults());
    }
}
