<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request;

use Swoox\Api\Api\Manager as ApiManager;

/**
 * Class Factory
 *
 * @package Swoox\Api\Model\Request
 */
class Factory
{

    /**
     * @var ApiManager
     */
    protected $apiM;
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * Factory constructor.
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * @return Delete\Factory
     */
    public function delete()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Delete\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Index\Factory
     */
    public function index()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Index\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Recommendation\Factory
     */
    public function recommendation()
    {

        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Recommendation\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Search\Factory
     */
    public function search()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Search\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Rules\Factory
     */
    public function rules()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Rules\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
