<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Rules;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 * @package Swoox\Api\Model\Request\Rules
 *
 * @Serializer\XmlRoot("request")
 */
class Request
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("clientId")
     * @Serializer\Type("integer")
     * @Assert\NotBlank()
     * @Assert\GreaterThan(0)
     *
     * @var int
     */
    private $clientId;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("ruleName")
     * @Serializer\XmlElement(cdata=false)
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $ruleName;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("requests")
     * @Serializer\Type("array<Swoox\Api\Model\Request\Rules\SingleRequest>")
     * @Serializer\XmlElement(cdata=false)
     * @Serializer\XmlList(inline=true,entry="requests")
     *
     * @var SingleRequest[]
     */
    private $requests;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("returnFields")
     * @Serializer\Type("array<string>")
     * @Serializer\XmlElement(cdata=false)
     * @Serializer\XmlList(inline=true,entry="returnFields")
     *
     * @var array
     */
    private $returnFields = [];

    /**
     * @return int
     */
    public function getClientId()
    {
        return $this->clientId;
    }

    /**
     * @param int $clientId
     * @return Request
     */
    public function setClientId($clientId)
    {
        $this->clientId = $clientId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRuleName()
    {
        return $this->ruleName;
    }

    /**
     * @param string $ruleName
     * @return Request
     */
    public function setRuleName($ruleName)
    {
        $this->ruleName = $ruleName;
        return $this;
    }

    /**
     * @return SingleRequest[]
     */
    public function getRequests()
    {
        return $this->requests;
    }

    /**
     * @param SingleRequest[] $requests
     * @return Request
     */
    public function setRequests($requests)
    {
        $this->requests = $requests;
        return $this;
    }

    /**
     * @return array
     */
    public function getReturnFields()
    {
        return $this->returnFields;
    }

    /**
     * @param array $returnFields
     * @return Request
     */
    public function setReturnFields($returnFields)
    {
        $this->returnFields = $returnFields;
        return $this;
    }
}
