<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Rules;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SingleRequest
 * @package Swoox\Api\Model\Request\Rules
 *
 * @Serializer\XmlRoot("requests")
 */
class SingleRequest
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("request")
     * @Serializer\Type("array<string, string>")
     * @Serializer\XmlElement(cdata=false)
     * @Serializer\XmlMap()
     *
     * @var array
     */
    private $requests;

    /**
     * @return array
     */
    public function getRequests()
    {
        return $this->requests;
    }

    /**
     * @param array $requests
     * @return SingleRequest
     */
    public function setRequests($requests)
    {
        $this->requests = $requests;
        return $this;
    }
}
