<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Index\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @package Berlitz\RestBundle\Model\Response\Token\PostToken
 *
 * @Serializer\XmlRoot("response")
 */
class Response
{

    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackid;

    /**
     * @Serializer\SerializedName("time")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $time;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $count;

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ItemsArray")
     * @Serializer\Type("array<Swoox\Api\Model\Response\Index\Swoox\Item>")
     * @Serializer\XmlList(entry="Item")
     *
     * @var Item[]
     */
    protected $items = array();

    /**
     * @return string
     */
    public function getStatus()
    {

        return $this->status;
    }

    /**
     * @param string $status
     *
     * @return Response
     */
    public function setStatus($status)
    {

        $this->status = $status;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getMessage()
    {

        return $this->message;
    }

    /**
     * @param mixed $message
     *
     * @return Response
     */
    public function setMessage($message)
    {

        $this->message = $message;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getTrackid()
    {

        return $this->trackid;
    }

    /**
     * @param mixed $trackid
     *
     * @return Response
     */
    public function setTrackid($trackid)
    {

        $this->trackid = $trackid;

        return $this;
    }

    /**
     * @return string
     */
    public function getTime()
    {

        return $this->time;
    }

    /**
     * @param string $time
     *
     * @return Response
     */
    public function setTime($time)
    {

        $this->time = $time;

        return $this;
    }

    /**
     * @return int
     */
    public function getCount()
    {

        return $this->count;
    }

    /**
     * @param int $count
     *
     * @return Response
     */
    public function setCount($count)
    {

        $this->count = $count;

        return $this;
    }

    /**
     * @return Item[]
     */
    public function getItems()
    {

        return $this->items;
    }

    /**
     * @param Item[] $items
     *
     * @return Response
     */
    public function addItem(Item $item)
    {

        $this->items[] = $item;

        return $this;
    }
}
