<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ValueArray
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 *
 * @Serializer\XmlRoot("DistanceArray")
 */
class DistanceArray
{

    /**
     * @Serializer\Type("ArrayCollection<Swoox\Api\Model\Response\Search\Filter\Distance>")
     * @Serializer\XmlList(inline=true, entry="Distance")
     *
     * @var Distance[]
     */
    protected $distance;


    public function __construct()
    {

        $this->distance = new ArrayCollection();
    }

    /**
     * @param Distance $distance
     *
     * @return $this
     */
    public function addDistance(Distance $distance)
    {

        if (!$this->distance->contains($distance)) {
            $this->distance->add($distance);
        }

        return $this;
    }

    /**
     * @return Distance[]
     */
    public function getDistance()
    {

        return $this->distance;
    }
}
