<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SelectedFilterArray
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 *
 * @Serializer\XmlRoot("SelectedFilterArray")
 */
class SelectedFilterArray
{

    /**
     * @Serializer\SerializedName("FilterHiddenArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterHiddenArray")
     *
     * @var FilterHiddenArray
     */
    protected $filterHiddenArray;
    /**
     * @Serializer\SerializedName("FilterMultiSelectArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterMultiSelectArray")
     *
     * @var FilterMultiSelectArray
     */
    protected $filterMultiSelectArray;
    /**
     * @Serializer\SerializedName("FilterRangeArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterRangeArray")
     *
     * @var FilterRangeArray
     */
    protected $filterRangeArray;
    /**
     * @Serializer\SerializedName("FilterValueArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterValueArray")
     *
     * @var FilterValueArray
     */
    protected $filterValueArray;

    /**
     * @return FilterHiddenArray
     */
    public function getFilterHiddenArray()
    {

        return $this->filterHiddenArray;
    }

    /**
     * @param FilterHiddenArray $filterHiddenArray
     *
     * @return SelectedFilterArray
     */
    public function setFilterHiddenArray($filterHiddenArray)
    {

        $this->filterHiddenArray = $filterHiddenArray;

        return $this;
    }

    /**
     * @return FilterRangeArray
     */
    public function getFilterMultiSelectArray()
    {

        return $this->filterRangeArray;
    }

    /**
     * @param FilterMultiSelectArray $filterMultiSelectArray
     *
     * @return SelectedFilterArray
     */
    public function setFilterMultiSelectArray($filterMultiSelectArray)
    {

        $this->filterMultiSelectArray = $filterMultiSelectArray;

        return $this;
    }

    /**
     * @return FilterRangeArray
     */
    public function getFilterRangeArray()
    {

        return $this->filterRangeArray;
    }

    /**
     * @param FilterRangeArray $filterRangeArray
     *
     * @return SelectedFilterArray
     */
    public function setFilterRangeArray($filterRangeArray)
    {

        $this->filterRangeArray = $filterRangeArray;

        return $this;
    }

    /**
     * @return FilterValueArray
     */
    public function getFilterValueArray()
    {

        return $this->filterValueArray;
    }

    /**
     * @param FilterValueArray $filterValueArray
     *
     * @return SelectedFilterArray
     */
    public function setFilterValueArray($filterValueArray)
    {

        $this->filterValueArray = $filterValueArray;

        return $this;
    }
}
