<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Standard;

use JMS\Serializer\Annotation as Serializer;
use Swoox\Api\Model\Response\Search\Interfaces\BasicResponseModelInterface;

/**
 * Class SearchResponse
 *
 * @package Swoox\Api\Model\Response\Search\Standard
 *
 * @Serializer\XmlRoot("SearchResponse")
 */
class SearchResponse implements BasicResponseModelInterface
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ResultsArray")
     * @Serializer\Type("array<Swoox\Api\Model\Response\Search\Standard\Item>")
     * @Serializer\XmlList(entry="Item")
     *
     * @var \Swoox\Api\Model\Response\Search\Standard\Item[]
     */
    protected $items = array();
    /**
     * @Serializer\SerializedName("Keywords")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $keywords;
    /**
     * @Serializer\SerializedName("ResultsCount")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $resultsCount;
    /**
     * @Serializer\SerializedName("ResultsLimit")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $resultsLimit;
    /**
     * @Serializer\SerializedName("ResultsOffset")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $resultsOffset;
    /**
     * @Serializer\SerializedName("ScriptSeconds")
     * @Serializer\Type("double")
     *
     * @var double
     */
    protected $scriptSeconds;
    /**
     * @Serializer\SerializedName("SpellingCorrection")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $spellingCorrection;

    /**
     * @param Item $item
     *
     * @return $this
     */
    public function addItem(Item $item)
    {

        $this->items[] = $item;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getItems()
    {

        return $this->items;
    }

    /**
     * @return string
     */
    public function getKeywords()
    {

        return $this->keywords;
    }

    /**
     * @param string $keywords
     *
     * @return SearchResponse
     */
    public function setKeywords($keywords)
    {

        $this->keywords = $keywords;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultsCount()
    {

        return $this->resultsCount;
    }

    /**
     * @param int $resultsCount
     *
     * @return SearchResponse
     */
    public function setResultsCount($resultsCount)
    {

        $this->resultsCount = $resultsCount;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultsLimit()
    {

        return $this->resultsLimit;
    }

    /**
     * @param int $resultsLimit
     *
     * @return SearchResponse
     */
    public function setResultsLimit($resultsLimit)
    {

        $this->resultsLimit = $resultsLimit;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultsOffset()
    {

        return $this->resultsOffset;
    }

    /**
     * @param int $resultsOffset
     *
     * @return SearchResponse
     */
    public function setResultsOffset($resultsOffset)
    {

        $this->resultsOffset = $resultsOffset;

        return $this;
    }

    /**
     * @return float
     */
    public function getScriptSeconds()
    {

        return $this->scriptSeconds;
    }

    /**
     * @param float $scriptSeconds
     *
     * @return SearchResponse
     */
    public function setScriptSeconds($scriptSeconds)
    {

        $this->scriptSeconds = $scriptSeconds;

        return $this;
    }

    /**
     * @return string
     */
    public function getSpellingCorrection()
    {

        return $this->spellingCorrection;
    }

    /**
     * @param string $spellingCorrection
     *
     * @return SearchResponse
     */
    public function setSpellingCorrection($spellingCorrection)
    {

        $this->spellingCorrection = $spellingCorrection;

        return $this;
    }
}
