<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Suggested;

/**
 * Class Factory
 *
 * @package Swoox\Api\Model\Response\Search\Suggested
 */
class Factory
{

    /**
     * @return Distance
     */
    public function distance()
    {

        return new Distance();
    }

    /**
     * @return DistanceArray
     */
    public function distanceArray()
    {

        return new DistanceArray();
    }

    /**
     * @return Filter
     */
    public function filter()
    {

        return new Filter();
    }

    /**
     * @return FilterDistanceArray
     */
    public function filterDistanceArray()
    {

        return new FilterDistanceArray();
    }

    /**
     * @return FilterHiddenArray
     */
    public function filterHiddenArray()
    {

        return new FilterHiddenArray();
    }

    /**
     * @return FilterItem
     */
    public function filterItem()
    {

        return new FilterItem();
    }

    /**
     * @return FilterRangeArray
     */
    public function filterRangeArray()
    {

        return new FilterRangeArray();
    }

    /**
     * @return FilterValueArray
     */
    public function filterValueArray()
    {

        return new FilterValueArray();
    }

    /**
     * @return Item
     */
    public function item()
    {

        return new Item();
    }

    /**
     * @return FilterMultiSelectArray
     */
    public function multiSelectArray()
    {

        return new FilterMultiSelectArray();
    }

    /**
     * @return SearchResponse
     */
    public function responseModel()
    {

        return new SearchResponse();
    }

    /**
     * @return SearchRecommendation
     */
    public function searchRecommendation()
    {

        return new SearchRecommendation();
    }

    /**
     * @return ValueArray
     */
    public function valueArray()
    {

        return new ValueArray();
    }
}
