<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Delete;

use PHPUnit\Framework\TestCase;
use Swoox\Api\Model\Request\Delete\Factory;

class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     *
     */
    public function setUp(): void
    {

        $this->factory = new Factory();
    }

    public function testCustom()
    {

        $custom = $this->factory->custom();

        $this->assertInstanceOf('Swoox\Api\Model\Request\Delete\Custom\Request', $custom);
    }

    public function testItem()
    {

        $item = $this->factory->item();

        $this->assertInstanceOf('Swoox\Api\Model\Request\Delete\Swoox\Item', $item);
    }

    public function testSwoox()
    {

        $swoox = $this->factory->swoox();

        $this->assertInstanceOf('Swoox\Api\Model\Request\Delete\Swoox\Request', $swoox);
    }
}
