<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Model\Request\Index\Swoox\Item;
use Swoox\Api\Model\Request\Index\Swoox\NameFieldList;
use Swoox\Api\Model\Request\Index\Swoox\Request;

/**
 * Class RequestTest
 *
 * @package Tests\Swoox\Api\Model\Request\Index\Swoox
 */
class RequestTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp(): void
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $jsonString = '{"UserData":{"ApiVersion":"1","AuthToken":"","ErrorLanguage":"en","ProjectId":"42","RefererURL":""},"ItemsArray":[{"DocumentLanguage":"de_DE","DocumentPrefix":"prefix","DocumentRanking":"11","DocumentText":"text","DocumentTitle":"title","DocumentURL":"http:\/\/localhost","DocumentUniqueKey":"xyz","DocumentFields":[{"Name":"test","Values":[]},{"Name":"test2","Values":[]}]}]}';

        $request = new Request();

        $item = new Item();
        $item->setDocumentUniqueKey('xyz');
        $item->setDocumentLanguage('de_DE');
        $item->setDocumentURL('http://localhost');
        $item->setDocumentTitle('title');
        $item->setDocumentPrefix('prefix');
        $item->setDocumentText('text');
        $item->setDocumentRanking(11);

        $nameFieldList = new NameFieldList();
        $nameFieldList->setName('test');
        $item->addDocumentFields($nameFieldList);

        $nameFieldList = new NameFieldList();
        $nameFieldList->setName('test2');
        $item->addDocumentFields($nameFieldList);

        $request->addItem($item);


        $this->assertEquals($jsonString, $this->serializer->serialize($request, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        $xml = file_get_contents('Tests/data/Swoox/Api/Model/Request/Index/Swoox/request.xml', true);

        /**
         * @var \Swoox\Api\Model\Request\Index\Swoox\Request $request
         */
        $request = $this->serializer->deserialize($xml, 'Swoox\Api\Model\Request\Index\Swoox\Request', 'xml');

        $this->assertInstanceOf('\Swoox\Api\Model\Request\Index\Swoox\UserData', $request->getUserData());

        $items = $request->getItems();

        $this->assertCount(2, $items);
        $this->assertInstanceOf('\Swoox\Api\Model\Request\Index\Swoox\Item', $items[0]);
    }
}
