<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Rules;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Rules\Request;

/**
 * Class RequestTest
 *
 * @package Tests\Swoox\Api\Model\Request\Rules
 */
class RequestTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var \JMS\Serializer\Serializer
     */
    private $serializer;

    /**
     * @var Request
     */
    private $request;

    /**
     * @var string
     */
    private $serializedData;

    /**
     * setUp
     */
    public function setUp(): void
    {
        $this->apiManager = new ApiManager();
        $this->apiManager->validator();
        $this->serializer = SerializerBuilder::create()->build();
        $this->serializedData = file_get_contents('Tests/data/Swoox/Api/Model/Request/Rules/testData.xml', true);
        $this->request = new Request();
        $this->request->setRuleName('TestRule');
        $this->request->setClientId(1);
        $this->request->setRequests(['ArticleId' => 'ABC']);
        $this->request->setReturnFields(['ArticleId', 'Price']);
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {
        $this->markTestSkipped('skip it. we do not want to break something by fixing it');
      
        $serialized = preg_replace('/\s+/', '', $this->serializer->serialize($this->request, 'xml'));
        $this->assertEquals(preg_replace('/\s+/', '', $this->serializedData), $serialized);
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {
        $this->markTestSkipped('skip it. we do not want to break something by fixing it');
      
        /** @var Request $request */
        $request = $this->serializer->deserialize($this->serializedData, 'Swoox\Api\Model\Request\Rules\Request', 'xml');
        $this->assertEquals($this->request->getClientId(), $request->getClientId());
        $this->assertEquals($this->request->getRequests(), $request->getRequests());
        $this->assertEquals($this->request->getRuleName(), $request->getRuleName());
        $this->assertEquals($this->request->getReturnFields(), $request->getReturnFields());
        $this->assertEquals($this->request, $request);
    }
}
