<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Search;

use Swoox\Api\Api\Manager as ApiManager;
use Swoox\Api\Model\Request\Search\Factory;

/**
 * Class FactoryTest
 *
 * @package Tests\Swoox\Api\Model\Request\Search
 */
class FactoryTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var Factory
     */
    private $factory;

    /**
     * setUp
     */
    public function setUp(): void
    {

        $this->factory = new Factory(new ApiManager());
    }

    /**
     * testFilter
     */
    public function testFilter()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Filter\Factory', $this->factory->filter());
    }

    /**
     * testStandard
     */
    public function testStandard()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Standard\Factory', $this->factory->standard());
    }

    /**
     * testSuggested
     */
    public function testSuggested()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Search\Suggested\Factory', $this->factory->suggested());
    }
}
