<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Delete\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Swoox XML-Node
 *
 * @package LifeStyle\Component\Swoox
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("UserData")
 */
class UserData
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ApiVersion")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $apiVersion = '1';
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("AuthToken")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $authToken = '';
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ErrorLanguage")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $errorLanguage = 'en';
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ProjectId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $projectId = '42';
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RefererURL")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $refererURL = '';

    /**
     * @return string
     */
    public function getApiVersion()
    {

        return $this->apiVersion;
    }

    /**
     * @return string
     */
    public function getAuthToken()
    {

        return $this->authToken;
    }

    /**
     * @return string
     */
    public function getErrorLanguage()
    {

        return $this->errorLanguage;
    }

    /**
     * @return string
     */
    public function getProjectId()
    {

        return $this->projectId;
    }

    /**
     * @return string
     */
    public function getRefererURL()
    {

        return $this->refererURL;
    }
}
