<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Suggested\Types;

use Swoox\Api\Model\Request\Search\Interfaces\DefaultsInterface;

/**
 * Class Defaults
 *
 * @package Swoox\Api\Model\Request\Search\Suggested\Types
 */
class Defaults implements DefaultsInterface
{
    use \Swoox\Api\Model\Request\Search\Traits\RequestDefaults;

    /**
     * @var string
     */
    protected $autocomplete;

    /**
     * @return string
     */
    public function getAutocomplete()
    {

        return $this->autocomplete;
    }

    /**
     * @param string $autocomplete
     *
     * @return Defaults
     */
    public function setAutocomplete($autocomplete)
    {

        $this->autocomplete = $autocomplete;

        return $this;
    }
}
