<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Swoox\Api\Model\Response\Search\Interfaces\FilterCollectionInterface;
use Swoox\Api\Model\Response\Search\Interfaces\FilterTypeInterface;

/**
 * Class FilterRangeArray
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 *
 * @Serializer\XmlRoot("FilterDistanceArray")
 */
class FilterDistanceArray implements FilterCollectionInterface
{

    /**
     * @Serializer\SerializedName("Filter")
     * @Serializer\Type("ArrayCollection<Swoox\Api\Model\Response\Search\Filter\Filter>")
     * @Serializer\XmlList(inline=true, entry="Filter")
     *
     * @var Filter[]
     */
    protected $filter;


    public function __construct()
    {

        $this->filter = new ArrayCollection();
    }


    /**
     * @return Filter[]
     */
    public function getFilters()
    {

        return $this->filter;
    }


    /**
     * @param FilterTypeInterface $filter
     *
     * @return FilterRangeArray
     */
    public function addFilter(FilterTypeInterface $filter)
    {

        if (!$this->filter->contains($filter)) {
            $this->filter->add($filter);
        }

        return $this;
    }
}
