<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Suggested;

use JMS\Serializer\Annotation as Serializer;
use Swoox\Api\Model\Response\Search\Interfaces\BasicResponseModelInterface;
use Swoox\Api\Model\Response\Search\Interfaces\FilterResponseModelInterface;

/**
 * Class SearchResponse
 *
 * @package Swoox\Api\Model\Response\Search\Suggested
 *
 * @Serializer\XmlRoot("SuggestedResponse")
 */
class SearchResponse implements BasicResponseModelInterface, FilterResponseModelInterface
{

    /**
     * @Serializer\SerializedName("FilterDistanceArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Suggested\FilterDistanceArray")
     *
     * @var FilterRangeArray
     */
    protected $filterDistanceArray;
    /**
     * @Serializer\SerializedName("FilterHiddenArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Suggested\FilterHiddenArray")
     *
     * @var FilterHiddenArray
     */
    protected $filterHiddenArray;
    /**
     * @Serializer\SerializedName("FilterMultiSelectArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Suggested\FilterMultiSelectArray")
     *
     * @var FilterMultiSelectArray
     */
    protected $filterMultiSelectArray;
    /**
     * @Serializer\SerializedName("FilterRangeArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Suggested\FilterRangeArray")
     *
     * @var FilterRangeArray
     */
    protected $filterRangeArray;
    /**
     * @Serializer\SerializedName("FilterValueArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Suggested\FilterValueArray")
     *
     * @var FilterValueArray
     */
    protected $filterValueArray;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ResultsArray")
     * @Serializer\Type("array<Swoox\Api\Model\Response\Search\Suggested\Item>")
     * @Serializer\XmlList(entry="Item")
     *
     * @var \Swoox\Api\Model\Response\Search\Suggested\Item[]
     */
    protected $items = [];
    /**
     * @Serializer\SerializedName("Keywords")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $keywords;
    /**
     * @Serializer\SerializedName("ResultsCount")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $resultsCount;
    /**
     * @Serializer\SerializedName("ResultsLimit")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $resultsLimit;
    /**
     * @Serializer\SerializedName("ResultsOffset")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $resultsOffset;
    /**
     * @Serializer\SerializedName("ScriptSeconds")
     * @Serializer\Type("double")
     *
     * @var double
     */
    protected $scriptSeconds;
    /**
     * @Serializer\SerializedName("SearchRecommendation")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Suggested\SearchRecommendation")
     *
     * @var SearchRecommendation
     */
    protected $searchRecommendation;
    /**
     * @Serializer\SerializedName("SpellingCorrection")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $spellingCorrection;

    /**
     * @param Item $item
     *
     * @return SearchResponse
     */
    public function addItem(Item $item)
    {

        $this->items[] = $item;

        return $this;
    }

    /**
     * @return FilterRangeArray
     */
    public function getFilterDistanceArray()
    {

        return $this->filterDistanceArray;
    }

    /**
     * @param FilterRangeArray $filterDistanceArray
     *
     * @return SearchResponse
     */
    public function setFilterDistanceArray($filterDistanceArray)
    {

        $this->filterDistanceArray = $filterDistanceArray;

        return $this;
    }

    /**
     * @return FilterHiddenArray
     */
    public function getFilterHiddenArray()
    {

        return $this->filterHiddenArray;
    }

    /**
     * @param FilterHiddenArray $filterHiddenArray
     *
     * @return SearchResponse
     */
    public function setFilterHiddenArray($filterHiddenArray)
    {

        $this->filterHiddenArray = $filterHiddenArray;

        return $this;
    }

    /**
     * @return FilterMultiSelectArray
     */
    public function getFilterMultiSelectArray()
    {

        return $this->filterMultiSelectArray;
    }

    /**
     * @param FilterMultiSelectArray $filterMultiSelectArray
     *
     * @return SearchResponse
     */
    public function setFilterMultiSelectArray($filterMultiSelectArray)
    {

        $this->filterMultiSelectArray = $filterMultiSelectArray;

        return $this;
    }

    /**
     * @return FilterRangeArray
     */
    public function getFilterRangeArray()
    {

        return $this->filterRangeArray;
    }

    /**
     * @param FilterRangeArray $filterRangeArray
     *
     * @return SearchResponse
     */
    public function setFilterRangeArray($filterRangeArray)
    {

        $this->filterRangeArray = $filterRangeArray;

        return $this;
    }

    /**
     * @return FilterValueArray
     */
    public function getFilterValueArray()
    {

        return $this->filterValueArray;
    }

    /**
     * @param FilterValueArray $filterValueArray
     *
     * @return SearchResponse
     */
    public function setFilterValueArray($filterValueArray)
    {

        $this->filterValueArray = $filterValueArray;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getItems()
    {

        return $this->items;
    }

    /**
     * @return string
     */
    public function getKeywords()
    {

        return $this->keywords;
    }

    /**
     * @param string $keywords
     *
     * @return SearchResponse
     */
    public function setKeywords($keywords)
    {

        $this->keywords = $keywords;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultsCount()
    {

        return $this->resultsCount;
    }

    /**
     * @param int $resultsCount
     *
     * @return SearchResponse
     */
    public function setResultsCount($resultsCount)
    {

        $this->resultsCount = $resultsCount;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultsLimit()
    {

        return $this->resultsLimit;
    }

    /**
     * @param int $resultsLimit
     *
     * @return SearchResponse
     */
    public function setResultsLimit($resultsLimit)
    {

        $this->resultsLimit = $resultsLimit;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultsOffset()
    {

        return $this->resultsOffset;
    }

    /**
     * @param int $resultsOffset
     *
     * @return SearchResponse
     */
    public function setResultsOffset($resultsOffset)
    {

        $this->resultsOffset = $resultsOffset;

        return $this;
    }

    /**
     * @return float
     */
    public function getScriptSeconds()
    {

        return $this->scriptSeconds;
    }

    /**
     * @param float $scriptSeconds
     *
     * @return SearchResponse
     */
    public function setScriptSeconds($scriptSeconds)
    {

        $this->scriptSeconds = $scriptSeconds;

        return $this;
    }

    /**
     * @return SearchRecommendation
     */
    public function getSearchRecommendation()
    {

        return $this->searchRecommendation;
    }

    /**
     * @param SearchRecommendation $searchRecommendation
     *
     * @return SearchResponse
     */
    public function setSearchRecommendation($searchRecommendation)
    {

        $this->searchRecommendation = $searchRecommendation;

        return $this;
    }

    /**
     * @return string
     */
    public function getSpellingCorrection()
    {

        return $this->spellingCorrection;
    }

    /**
     * @param string $spellingCorrection
     *
     * @return SearchResponse
     */
    public function setSpellingCorrection($spellingCorrection)
    {

        $this->spellingCorrection = $spellingCorrection;

        return $this;
    }
}
