<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Delete\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @package Swoox\Api\Model\Request\Delete\Swoox
 *
 * @Serializer\XmlRoot("DeleteFromIndexRequest")
 */
class Request
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("UserData")
     * @Serializer\Type("Swoox\Api\Model\Request\Delete\Swoox\UserData")
     *
     * @var \Swoox\Api\Model\Request\Delete\Swoox\UserData
     */
    protected $userData;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ItemsArray")
     * @Serializer\Type("array<Swoox\Api\Model\Request\Delete\Swoox\Item>")
     * @Serializer\XmlList(entry="Item")
     *
     * @var \Swoox\Api\Model\Request\Delete\Swoox\Item[]
     */
    protected $items = array();

    /**
     * Request constructor.
     */
    public function __construct()
    {

        $this->userData = new UserData();
    }

    /**
     * @param Item $item
     *
     * @return $this
     */
    public function addItem(Item $item)
    {

        $this->items[] = $item;

        return $this;
    }

    /**
     * @return Item[]
     */
    public function getItems()
    {

        return $this->items;
    }

    /**
     * @return UserData
     */
    public function getUserData()
    {

        return $this->userData;
    }
}
