<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Item
 *
 * @package Swoox\Api\Model\Request\Index\Swoox
 *
 * @Serializer\XmlRoot("Item")
 */
class Item
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentLanguage")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentLanguage;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentPrefix")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentPrefix;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentRanking")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentRanking;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentText")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentText;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentTitle")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentTitle;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentURL")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentURL;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentUniqueKey")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $documentUniqueKey;
    /**
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DocumentFields")
     * @Serializer\Type("array<Swoox\Api\Model\Request\Index\Swoox\NameFieldList>")
     * @Serializer\XmlList(entry="NameFieldList")
     *
     * @var \Swoox\Api\Model\Request\Index\Swoox\NameFieldList[]
     */
    protected $documentFields = array();

    /**
     * @return NameFieldList[]
     */
    public function getDocumentFields()
    {

        return $this->documentFields;
    }

    /**
     * @param NameFieldList[] $documentFields
     *
     * @return Item
     */
    public function setDocumentFields($documentFields)
    {

        $this->documentFields = $documentFields;

        return $this;
    }

    /**
     * @param NameFieldList $documentField
     *
     * @return $this
     */
    public function addDocumentFields(NameFieldList $documentField)
    {

        $this->documentFields[] = $documentField;

        return $this;
    }

    /**
     * @return string
     */
    public function getDocumentLanguage()
    {

        return $this->documentLanguage;
    }

    /**
     * @param string $documentLanguage
     *
     * @return Item
     */
    public function setDocumentLanguage($documentLanguage)
    {

        $this->documentLanguage = $documentLanguage;

        return $this;
    }

    /**
     * @return string
     */
    public function getDocumentPrefix()
    {

        return $this->documentPrefix;
    }

    /**
     * @param string $documentPrefix
     *
     * @return Item
     */
    public function setDocumentPrefix($documentPrefix)
    {

        $this->documentPrefix = $documentPrefix;

        return $this;
    }

    /**
     * @return string
     */
    public function getDocumentRanking()
    {

        return $this->documentRanking;
    }

    /**
     * @param string $documentRanking
     *
     * @return Item
     */
    public function setDocumentRanking($documentRanking)
    {

        $this->documentRanking = $documentRanking;

        return $this;
    }

    /**
     * @return string
     */
    public function getDocumentText()
    {

        return $this->documentText;
    }

    /**
     * @param string $documentText
     *
     * @return Item
     */
    public function setDocumentText($documentText)
    {

        $this->documentText = $documentText;

        return $this;
    }

    /**
     * @return string
     */
    public function getDocumentTitle()
    {

        return $this->documentTitle;
    }

    /**
     * @param string $documentTitle
     *
     * @return Item
     */
    public function setDocumentTitle($documentTitle)
    {

        $this->documentTitle = $documentTitle;

        return $this;
    }

    /**
     * @return string
     */
    public function getDocumentURL()
    {

        return $this->documentURL;
    }

    /**
     * @param string $documentURL
     *
     * @return Item
     */
    public function setDocumentURL($documentURL)
    {

        $this->documentURL = $documentURL;

        return $this;
    }

    /**
     * @return string
     */
    public function getDocumentUniqueKey()
    {

        return $this->documentUniqueKey;
    }

    /**
     * @param string $documentUniqueKey
     *
     * @return Item
     */
    public function setDocumentUniqueKey($documentUniqueKey)
    {

        $this->documentUniqueKey = $documentUniqueKey;

        return $this;
    }
}
